c     this is a trial to suppress very large x part by making an
c     intermediate routine chncol2 which is the original chncol.
c     And on top of it, chncol is made.
c     *****************************************************************
c     *                                                               *
c     * chncol: hadron nucleon collision
c     *                                                               *
c     *****************************************************************

       subroutine chncol(pj, tg, a, ntp, icon)
c             pj:  structure /ptcl/. Input. to give the incident
c                  projectile hadron in the Lab. system.
c             tg:  structure /ptcl/. Input. to give the target
c                  nucleon in the Lab. system.
c              a:  array of structure /ptcl/. Output. to get
c                  produced particles.
c            ntp:  integer. Output. to get the total number of produced
c                  particles in a.
c           icon:  Integer. Output. if 0, particle generation is ok
c                   if non 0, you may give up generation.
c
c                 Note: target recoil is put in a(ntp-1),
c                       projectile recoil is put in a(ntp)
c
       implicit none

#include  "Zptcl.h"
#include  "Zevhnv.h"
c
c
       record /ptcl/ pj, tg,  a(*)
       integer ntp, icon
       integer i
       real*8 u, xmax

       do while (.true.)
          call chncol2(pj, tg, a, ntp, icon)
          if(icon .ne. 0) goto 100
c             find max secondary energy.
          xmax = 0.
          do i = 1, ntp-2
             if(xmax .lt. a(i).fm.p(4)) xmax = a(i).fm.p(4)
          enddo
          xmax = xmax/pj.fm.p(4)
c              if very large x appears, discard it
c              with some probabilty to adjust
c              the x-distribution.
          if(xmax .gt. 0.5) then
             call rndc(u)
             if(u .lt.  (1. - 2*(xmax-0.5))) then
                goto 100
             endif
          else
             goto 100
          endif
       enddo
 100   continue
       end

c     *****************************************************************
c     *                                                               *
c     * chncol2: hadron nucleon collision
c     *                                                               *
c     *****************************************************************
c
c

       subroutine chncol2(pj, tg, a, ntp, icon)
