      subroutine cintePhoton
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
      character*70 msg

c
      if(IntInfArray(ProcessNo).process .eq. 'pair') then
         call cpair
      elseif(IntInfArray(ProcessNo).process .eq. 'compt') then
         call ccompt
      elseif(IntInfArray(ProcessNo).process .eq. 'photoe') then
c         call cphtoEE  ! at present,  neglected  ********************
      elseif(IntInfArray(ProcessNo).process .eq. 'photop') then
         call cphotop
      elseif(IntInfArray(ProcessNo).process .eq. 'mpair') then
         call cmpair
      else
         write(msg, *) ' process for photon',
     *        IntInfArray(ProcessNo).process, ' undef'
         call cerrorMsg(msg,  0)
      endif
      end
c     *******************
      subroutine cpair
c     *******************
      implicit none

#include  "Zcode.h"
#include  "Zmass.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

c
      real*8 e1, e2, u, eg, cs, sn
      real*8 teta, teta1, teta2, cos1, sin1, cos2, sin2
      integer ica
      real*8 den, cvh2den
      record /track/aTrack
      record /coord/ dc, dce
      real*8 temp
c     
      eg = MovedTrack.p.fm.p(4)
      if(LpmEffect .and. eg .gt. LpmPairEmin) then
c         den = cthick2den(TrackBefMove.pos.depth)
         den = cvh2den(TrackBefMove.pos.height)  ! better
         call cpairErgLPM(eg, den, e1)
      else
         call cpairEnergy(eg, e1)
      endif

      e2=eg - e1
      if( e1 .gt. e2) then
c          store higher energy ptcl later
         temp = e1
         e1= e2
         e2 = temp
      endif
c            assign charge for e1
      call rndc(u)
      if(u .gt. .5) then
         ica=1
      else
         ica=-1
      endif
c     
      aTrack = MovedTrack
      if(eg .lt. 100.e-3) then
c          take pair angle if < 100 MeV
         call kcossn(cs, sn)

         teta = masele/eg
         teta1=teta* e2/eg
         teta2=teta* e1/eg
         cos1=1. - teta1**2/2
         cos2=1. - teta2**2/2
c               sample direction cos. of 1st
         sin1=teta1
         dc.r(1) = cs * sin1
         dc.r(2) = sn * sin1
         dc.r(3)=  cos1
         call ctransVectZ(MovedTrack.vec.w, dc, dce)

         call cmkptc(kelec, 0, ica, aTrack.p)
         aTrack.p.fm.p(4) = e1
         call csetDirCos(dce, aTrack)
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p
c            another electron
         sin2=teta2
         dc.r(1) = -cs*sin2
         dc.r(2) = -sn*sin2
         dc.r(3) = cos2
         call ctransVectZ(MovedTrack.vec.w, dc, dce)
         aTrack.p.fm.p(4) = e2
         call cmkptc(kelec, 0, -ica,  aTrack.p)
         call csetDirCos(dce, aTrack)
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p
      else
c          neglect pair angle
         aTrack.p.fm.p(4) = e1
         call ce2p(aTrack)
         call cmkptc(kelec, 0, ica, aTrack.p)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p
c     
         aTrack.p.fm.p(4) = e2
         call ce2p(aTrack)
         call cmkptc(kelec, 0, -ica, aTrack.p)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p
      endif
      end
c     ***********
      subroutine ccompt
c     ***********
      implicit none
c----      include '../Particle/Zcode.h'
#include  "Zcode.h"
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c
      record /track/aTrack
      real*8 eg, e1, cs, sn, cosg, cose
      real*8 sine, tmp, sing
      record /coord/ dc, dce, dcg
c  
      call ccomptEnergy(MovedTrack.p.fm.p(4), eg, e1)
c                         sample angle of e
      call kcossn(cs,sn)
      call ccomptAngle(cosg, cose)
c           electron direction
      tmp=max(1.d0-cose*cose, 0.d0)
      sine=sqrt(tmp)
      dc.r(1)=cs*sine
      dc.r(2)=sn*sine
      dc.r(3)=cose
      call ctransVectZ(MovedTrack.vec.w, dc, dce)
      aTrack = MovedTrack
      call cmkptc(kelec, 0, -1, aTrack.p)
      aTrack.p.fm.p(4) = e1
      call csetDirCos(dce, aTrack)
      call ce2p(aTrack)
      Nproduced = Nproduced + 1
      Pwork(Nproduced) = aTrack.p
c            gamma dicrection
      tmp=max(1.d0-cosg*cosg, 0.d0)
      sing=sqrt(tmp)
      dc.r(1) = -cs*sing
      dc.r(2) = -sn*sing
      dc.r(3) = cosg
      call ctransVectZ(MovedTrack.vec.w, dc, dcg)
      aTrack.p.fm.p(4) = eg
      call cmkptc(kphoton, kcasg, 0, aTrack.p)
      call csetDirCos(dcg, aTrack)
      Nproduced = Nproduced + 1
      Pwork(Nproduced) = aTrack.p

      end
c     ***********
      subroutine cphotop
c     ***********
      implicit none
c----      include '../Particle/Zcode.h'
#include  "Zcode.h"
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c
c      record /track/aTrack
c      integer i
c
      call cgpHad(TargetNucleonNo, TargetProtonNo, 
     *   MovedTrack.p, 2, Pwork, Nproduced)
c     
c      aTrack = MovedTrack
c      do i = 1, Nproduced
c         aTrack.p = Pwork(i)
c         call cpush(aTrack)
c      enddo
      end
c     *******************
      subroutine cmpair
c         magnetic pair creation
c     *******************
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      real*8 e1, e2, u
      integer ica, nc
      record /track/aTrack
c       
      call cmPairE(Xai, e2, nc)
c           e2 is higher energy fraction; change to real energy
c         store later in  working array, then higher one is
c        stored first in the stack to save the memory.
      e2 = MovedTrack.p.fm.p(4) * e2
      e1=MovedTrack.p.fm.p(4) - e2
c            assign charge for e1
      call rndc(u)
      if(u .gt. .5) then
         ica=1
      else
         ica=-1
      endif
c     
      aTrack = MovedTrack
      aTrack.p.fm.p(4) = e1
      call ce2p(aTrack)
      call cmkptc(kelec, 0, ica, aTrack.p)
      Nproduced = Nproduced + 1
      Pwork(Nproduced) = aTrack.p

      aTrack.p.fm.p(4) = e2
      call ce2p(aTrack)
      call cmkptc(kelec, 0, -ica, aTrack.p)
      Nproduced = Nproduced + 1
      Pwork(Nproduced) = aTrack.p
      end
