#include "chookHybAS.f"
#include "ctemplCeren.f"
#include "ZcosmosBD.h"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"

c          ///////////
      integer nl, nth
      parameter (nl = 20, nth=12)
      common /testcos/x(1000), y(1000), erg(1000), eth(nth),
     * ng(nth, nl), ne(nth, nl), nmu(nth, nl), 
     * nh(nth, nl), ntha, nnn
      integer ng, ne, nmu, nh, ntha, nnn
      real*8 eth, x, y, erg
c     //////////////

c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.
#ifdef sun4
      external csigHandler
      integer  ieeer, ieee_handler

      ieeer = ieee_handler('set', 'invalid', csigHandler)
#endif

c
c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)

      eth(1) = 0.3d-3
      eth(2) = 0.5d-3
      eth(3)=  1.d-3
      eth(4) = 2.d-3
      eth(5) = 5.d-3
      eth(6) = 10.d-3
      eth(7) = 20.d-3
      eth(8)=  50.d-3
      eth(9) = 100.d-3
      eth(10) = 200.d-3
      eth(11) = 500.d-3
      eth(12) = 1.d0

c      ////////////
      ntha = 1  !  for each ptcle out put use only 1 threshold
c     /////////////
      end
#ifdef sun4
      integer function csigHandler(sig, code, context)
      implicit none
#include "Zmanagerp.h"
      integer sig, code, context(5)
      write(ErrorOut, *)  ' f.p exception content=' , context(4)
c      call abort()
      end
#endif

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"

c          ///////////
      integer nl, nth
      parameter (nl = 20, nth=12)
      common /testcos/x(1000), y(1000), erg(1000), eth(nth),
     * ng(nth, nl), ne(nth, nl), nmu(nth, nl), 
     * nh(nth, nl), ntha, nnn
      integer ng, ne, nmu, nh, ntha, nnn
      real*8 eth, x, y, erg
c     //////////////




      record /track/ inci
      record /coord/ angle

      integer  nev
c     //////////////
      integer i, j
      integer seed(2)
      do i = 1, nl
         do j = 1, ntha
            ng(j, i) = 0
            ne(j, i) = 0
            nh(j, i) = 0
            nmu(j, i) = 0
         enddo
      enddo
      nnn = 0
c      write(*, *)
c      call cqIncident(inci, angle)
c      write(*,'(i7,i4,g13.4,3f10.7)') EventNo, inci.p.code, inci.p.fm.e,
c     *  -angle.r(1),  -angle.r(2), -angle.r(3)      
      end
      subroutine ccount(nc, aTrack)
      implicit none
#include "Zcode.h"
#include "Ztrack.h"

      record /track/ aTrack
      integer i
c          ///////////
      integer nl, nth
      parameter (nl = 20, nth=12)
      common /testcos/x(1000), y(1000), erg(1000), eth(nth),
     * ng(nth, nl), ne(nth, nl), nmu(nth, nl),
     * nh(nth, nl), ntha, nnn
      integer ng, ne, nmu, nh, ntha, nnn
      real*8 eth, x, y, erg
c
      integer nc(nth, nl)

      do i = 1, ntha
        if( aTrack.p.fm.e- aTrack.p.mass .lt. eth(i)) goto 10
        nc(i, aTrack.where) =  nc(i, aTrack.where) + 1
      enddo
 10   continue 
      end
c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include  "Zheavyp.h"
      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
      record /track/ inci
      record /coord/ angle, tetafai
c      integer i
c          ///////////

c          ///////////
      integer nl, nth
      parameter (nl = 20, nth=12)
      common /testcos/x(1000), y(1000), erg(1000), eth(nth),
     * ng(nth, nl), ne(nth, nl), nmu(nth, nl), 
     * nh(nth, nl), ntha, nnn
      integer ng, ne, nmu, nh, ntha, nnn
      real*8 eth, x, y, erg
c     //////////////

      integer iij



c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
c      if(id .eq. 2 .and. aTrack.p.code .eq. kmuon ) then
       if( id .eq. 2) then
           call cqIncident(inci, angle)
           iij = aTrack.p.code  
c          call cgpid(iij, ptclid)
           if(iij .eq. kelec ) then
              call ccount(ne, aTrack)
              nnn = nnn + 1
              x(nnn) = aTrack.pos.xyz.x
              y(nnn) = aTrack.pos.xyz.y
              erg(nnn) = aTrack.p.fm.p(4)
c              ne(aTrack.where) = ne(aTrack.where) + 1
           elseif(iij  .eq. kphoton ) then
              call ccount(ng, aTrack)
              nnn = nnn + 1
              x(nnn) = aTrack.pos.xyz.x
              y(nnn) = aTrack.pos.xyz.y
              erg(nnn) = aTrack.p.fm.p(4)

c              ng(aTrack.where) = ng(aTrack.where) + 1
           elseif(iij .eq. kmuon ) then
              call ccount(nmu, aTrack)
c              nmu(aTrack.where) = nmu(aTrack.where) + 1
           elseif( iij .eq. kpion  .or. iij .eq.  kkaon .or. 
     *        iij .eq. knuc) then
              if(aTrack.p.charge .ne. 0 ) then
                 call ccount(nh, aTrack)
c                 nh(aTrack.where) = nh(aTrack.where) + 1
              endif
           endif
        endif

c            output typical quantities.
c         id .eq. 2 below  if want otuput
c        if(id .eq. 2 .and. aTrack.where .eq.  8 ) then
c        if(id .eq. 2 .and. aTrack.where .eq.  1 ) then
        if(id .eq. 2 ) then
c         if(aTrack.p.code .ne. kneue .and. aTrack.p.code .ne. 
c     *    kneumu) then
c           write(*,*) aTrack.where,  aTrack.p.code,  aTrack.p.subcode,
c     *      aTrack.p.charge, 
c     *     sngl(aTrack.p.fm.e-aTrack.p.mass)
c     *      sngl(aTrack.vec.coszenith),
c     *      sngl(inci.p.fm.p(4)-inci.p.mass)/
c     *      Code2massN(int(inci.p.code)),
c     *      inci.p.code
c     
c       write(*,
c     *  '(i2,1x,i2,1x,f12.2, g13.4, f12.2,1x, f12.2,1x,f7.4,i3)')
c     * nev, 
c     *  aTrack.where,   !  observation level. integer*2.  1 is highest.
c     *  aTrack.p.code,  ! " ", ptclid,    !  ptcl code.  integer*2.
c     *  aTrack.p.charge,  !  charge,  integer*2 
c     *  sngl(aTrack.t), !  relateive arrival time in nsec (NOT sec).
c                        !  if TimeStructure is F, nonsense.
c     *  sngl(aTrack.p.fm.e), !  - aTrack.p.mass), ! kinetic energy in GeV
c     *  sngl(aTrack.pos.xyz.x), sngl(aTrack.pos.xyz.y),  !  x, y, erg in m
c     *  sngl(aTrack.vec.w.x),  ! direc. cos.x in the current detector system.
c     *  sngl(aTrack.vec.w.y),  ! direc. cos.y
c     *  sngl(aTrack.vec.w.z),  ! direc. cos.z
c     * sngl(-angle.r(3)) ,
c     * sngl(aTrack.vec.coszenith),  ! cos of zenith angle
c     * sngl(inci.p.fm.p(4)-inci.p.mass)/Code2massN(int(inci.p.code)),
c     * inci.p.code
c         if(aTrack.p.code .eq. kelec) then
c            write(*, *) aTrack.where
c         endif
c      endif
c         you may need in some case other information such as
c     *  aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
c                           ! ThinSampling =T)
c       aTrack.p.fm.x      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.y      !          y
c       aTrack.p.fm.z      !          z
c        if(aTrack.p.code .eq. kelec .or. aTrack.p.code .eq. kphoton) 
c     *     then
c           ng = ng+1
c           sumg = sumg + aTrack.p.fm.e

c        endif
      endif
      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"




      record /track/ inci
      record /coord/ angle, tetafai
      integer i, j

c          ///////////
      integer nl, nth
      parameter (nl = 20, nth=12)
      common /testcos/x(1000), y(1000), erg(1000), eth(nth),
     * ng(nth, nl), ne(nth, nl), nmu(nth, nl), 
     * nh(nth, nl), ntha, nnn
      integer ng, ne, nmu, nh, ntha, nnn
      real*8 eth, x, y, erg
c     //////////////



c          ///////////
      real*8  fdepth, bsin, teta, fai, sumsize
      real*8  cgetBsin, sumx, sumy
      real*8 avex,  avey, sume
      integer nnew
c     //////////////
c       call cqIncident(inci, angle)
c      write(*,*) inci.vec.coszenith, angle.r(3)

      if(ObserveAS) then
         call cqFirstID(fdepth)
         fdepth = fdepth * 0.1         ! in g/cm2
         call cqIncident(inci, angle)
         angle.r(1) = -angle.r(1)   ! angle is directed to downward
         angle.r(2) = -angle.r(2)
         angle.r(3) = -angle.r(3)
         call ceCent2sph(angle, tetafai)
         teta = tetafai.r(1) 
         fai = tetafai.r(2)
         if(fai  .lt. 0. ) fai = 360.d0+fai
         bsin = cgetBsin(inci.p, Mag)*1.e4
c                   electron size in B approx.
c         write(*, *) (ASObsSites(i).esize, i=1, NoOfASSites)
c                   size weighted age
c         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites) 
         sumsize = 0.
c         write(*, *)
        do j = 1, ntha
          if(ntha .gt. 1) then
c             write(*,*) j
          endif
           do i = 1, NoOfASSites
              sumsize = sumsize + ASObsSites(i).esize
               write(*, '(f7.1,g13.3,f8.3,f7.1,
     *             4i8,f7.4)')
c     *       f8.3,    g13.3,f10.3,f10.3) ')
c     *           sngl(ASObsSites(i).pos.depth/10./angle.r(3)),
     *           sngl(ASObsSites(i).pos.depth/10.),
     *           sngl(ASObsSites(i).esize), 
     *           sngl(ASObsSites(i).age), sngl(fdepth),
c     *           sngl(bsin), sngl(sumsize), sngl(teta), sngl(fai)  
     *           ne(j, i), nmu(j, i), nh(j, i), ng(j, i), eth(j)
            enddo
         enddo
      endif
      do j = 1, 3
         call cgetave(x, nnn, avex)
         call cgetave(y, nnn, avey)
         call cgetave(erg, nnn, sume)
         sume = sume * nnn
         if(nnn .ge.  4) then
            sumx = 0.
            do i = 1, nnn
               x(i) = x(i) - avex
               y(i) = y(i) - avey
               sumx = sumx +sqrt(x(i)**2 +  y(i)**2)
            enddo
            call cdropBig(x, y, nnn, 15.d-2, nnew)
            if(nnew .eq. nnn) goto  100
            nnn = nnew
         else
            goto 100
         endif
      enddo
 100  continue
       if(nnn .ge . 4) then
         call cqIncident(inci, angle)
         call cqFirstID(fdepth)
         fdepth = fdepth * 0.1         ! in g/cm2
         write(*,*) sngl(avex*100.), sngl(avey*100.),
     *           sngl(sumx/nnn)*100., nnn, sngl(sume/1000.),
     *  inci.p.code, sngl(inci.p.fm.p(4)/1000.),
     *  sngl(-angle.r(3))
       endif
c      write(*, *)
      end
      subroutine cdropBig(x, y, n,  rmax,  no)
      implicit none
      integer n, no
      real*8 x(n), y(n), rmax
      real*8 r
      integer  i
      no =0
      do i = 1, n
         r = sqrt(x(i)**2 + y(i)**2)
         if(r .le. rmax) then
            no = no + 1
            x(no)= x(i)
            y(no) = y(i)
         endif
      enddo
      end
      subroutine cgetave(x, n, ave)
      implicit none
      real*8 x(n)
      integer n

      integer i
      real*8 ave
      ave = 0.
      do i = 1, n
         ave = ave + x(i)
      enddo
      if(n .gt. 1) then
         ave = ave/n
      endif
      end
c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 100
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 100
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end

c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat', 'anihi' or 'mbrem'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' 'photop' 'mpair'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none


#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
c
c      never = 1
        never = 1
        if(MovedTrack.p.code .eq.  kpion .or.
     *       MovedTrack.p.code .eq.  kkaon) then
            if(IntInfArray(ProcessNo).process .eq. 'coll') then
c              write(*,*)
c     *         MovedTrack.p.code,
c     *         sngl(MovedTrack.p.fm.p(4)), Nproduced
           endif
        endif
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
      end

      





