c       ccompPathEnd
c       compute path end information. including multiple scattering and mag.
c       deflection
c
      subroutine ccompPathEnd
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
c
c
c         get endpoint coord. assuming no scat, no mag. effect. at first
c         MovedTrack has complete information at path end.
       MovedTrack = TrackBefMove   !   copy TrackBefMove into MovedTrack. 
       call cmoveStreight(IntInfArray(ProcessNo).length)
c         If a chargde ptcl, compute energy loss by dE/dx  and  reset energy
c         in MovedTrack. If it is too large, path is truncated. Also compute
c         deflection.
c
       if(TrackBefMove.p.charge .ne. 0) then
          if(.not. (mod(HowGeomag, 10) .eq. 1 .and.
     *                Zfirst .eq. 0.)) then
             call cputEnergyLoss
          endif
          if(MoveStat .ne. Dead) then
             call cputDeflection
          endif
       endif
       end
c     --------------------------------------------------------
       subroutine cmoveStreight(leng)
c        move a track by leng m
c         after this is called,  MovedTrack has inf for moved pos.
c         MovedTrack.pos.where may not be correct. It must be
c         corrected by seeing if the track passes acrosss a
c         observation layer.
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zearth.h"


       real*8  leng, cnewcos
c
c            new coord in xyz system.

       MovedTrack.pos.xyz.r(1) = TrackBefMove.pos.xyz.r(1)
     *                      + TrackBefMove.vec.w.r(1) * leng
       MovedTrack.pos.xyz.r(2) = TrackBefMove.pos.xyz.r(2)
     *                      + TrackBefMove.vec.w.r(2) * leng
       MovedTrack.pos.xyz.r(3) = TrackBefMove.pos.xyz.r(3)
     *                      + TrackBefMove.vec.w.r(3) * leng
       call csetPos(MovedTrack.pos) ! set height, radial length, thickness
c            get new cos
       MovedTrack.vec.coszenith = cnewcos(MovedTrack.pos.radiallen,
     *  TrackBefMove.vec.coszenith, leng)
       if(TimeStructure ) then
          call cgetBeta(MovedTrack.p, Beta)  
c             note righthand is not MovedTrack.t
          if(Beta .gt. 0.) then
             MovedTrack.t = TrackBefMove.t + leng/Beta
          endif
       endif
       end
c      -----------------------------------
       subroutine cputEnergyLoss
c         observation layer.
       implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
 
c     
       real*8  rho, cvh2den, dedt, thick, leng, cupsilon
       save dedt
       real*8  csyncTELoss
       integer jcut
       real*8  dedx  ! output.  dedt is put
c
c          first consider the synchrotron loss.
c
       if( TrackBefMove.p.fm.p(4) .gt. MagBremEmin) then
         if( MagBrem .eq. 1 .and. TrackBefMove.p.code .eq. kelec) then
	    Upsilon = cupsilon(TrackBefMove.p, Mag)
	    if(Upsilon .gt. UpsilonMin) then
c                 compute energy loss due to sychrotron rad.
                 EnergyLoss = csyncTELoss(Upsilon) * 
     *           IntInfArray(ProcessNo).length
                 if(Reverse .eq. 0) then
                    MovedTrack.p.fm.p(4) = 
     *                MovedTrack.p.fm.p(4) -  EnergyLoss
                 elseif(Reverse .eq. 2) then
                    MovedTrack.p.fm.p(4) = 
     *                MovedTrack.p.fm.p(4) +  EnergyLoss
                 endif
c                 don't  worry about death
	    endif
         endif
       endif 
c            
c           dE/dX
c
       rho = cvh2den(TrackBefMove.pos.height)
       call cdedxInAir(TrackBefMove.p, rho, dedt)
       EnergyLoss =  dedt * IntInfArray(ProcessNo).thickness

       if(Reverse .eq. 0) then
           MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) -  EnergyLoss          
c           see if <=mass
           if(MovedTrack.p.fm.p(4) .lt. MovedTrack.p.mass) then
              EnergyLoss =( TrackBefMove.p.fm.p(4) - MovedTrack.p.mass )
              if(dedt .gt. 0.) then
                 thick =EnergyLoss / dedt
              else
                 thick = 0.
              endif
              MovedTrack.p.fm.p(4) = MovedTrack.p.mass

              call cthick2len(TrackBefMove.pos.height, 
     *          TrackBefMove.vec.coszenith, thick, leng, thick, jcut)

c               reset position information in MovedTrack
              call cmoveStreight(leng)
              MoveStat = Truncated
           endif
c                reset 3 momenta px, py, pz 
c                 (but assume direction is unchanged)
           call ce2p(MovedTrack)
       elseif(Reverse .eq. 2) then
          MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) +  EnergyLoss
c                reset 3 momenta px, py, pz 
c                 (but assume direction is unchanged)
          call ce2p(MovedTrack)
c          MoveStat = Truncated
       else
c          MoveStat = Truncated
       endif 
       return
c      **************
       entry cqElossRate(dedx)
c      **************
c         inquire the dedt; which may be used when particle cross 
c         an obs. level and recompute the energy
       dedx = dedt
       end
c      --------------------------------------------------------------
       subroutine cputDeflection
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

c
       real*8 dt, dispx, dispy
       logical nodef


       if(Reverse .eq. 0) then
          nodef = OneDim .ne. 0  .or.
     *    (mod(HowGeomag, 10) .eq. 1 .and. Zfirst .eq. 0.)
       else
          nodef = .false.
       endif
       if(.not. nodef) then
c
c         compute   magnetic deflection first. independently of scattering.
c         system is xyz
          call cmagDef
       endif
       if(.not. nodef .and. Reverse .eq. 0) then
          call celecDef(dispx, dispy)
       endif
       if(.not. nodef) then
          call csetPos(MovedTrack.pos)
          call cgetZenith(MovedTrack, MovedTrack.vec.coszenith)
c          reset momentum to be compatible with direction cos.
          call cresetMom(MovedTrack)
c
          if(TimeStructure .and. Reverse .eq. 0) then  ! only for mul. scat
c                compute excess path length to be added to streight path
             call cexcessLen(dispx, dispy, dt)
             if(Beta .gt. 0.) then
                MovedTrack.t = MovedTrack.t + dt/Beta
             endif
          endif
       endif
       end
c      *************************
       subroutine cmagDef
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

c

c              by  Geomag  (dr and ddirec)
       record /coord/ dispmr, dispmd
       real*8  leng,  norm
       integer i

       leng = IntInfArray(ProcessNo).length
       call cmagneticDef(TrackBefMove, Mag, leng,
     *     dispmr, dispmd)

       do i = 1,  3
c               displacement
          MovedTrack.pos.xyz.r(i) = MovedTrack.pos.xyz.r(i) +
     *         dispmr.r(i)
c               direction
          MovedTrack.vec.w.r(i) = MovedTrack.vec.w.r(i) +
     *         dispmd.r(i)
       enddo
c           normalize
       norm = sqrt(MovedTrack.vec.w.r(1)**2 +
     *            MovedTrack.vec.w.r(2)**2 +
     *            MovedTrack.vec.w.r(3)**2)
       do i = 1, 3
           MovedTrack.vec.w.r(i) = MovedTrack.vec.w.r(i)/norm
       enddo
       end
c      ==============================================================
       subroutine celecDef(dispx, dispy)
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

       real*8 dispx, dispy  ! output. scatttering displacement
c
       record /coord/ dircos
c              by  Multiple Scattering

       real*8 tetax, tetay

       real*8 leng

       integer i

       leng = IntInfArray(ProcessNo).length

c           Multiples csattering. around MovedTrack
       call cmulScat(dispx, dispy, tetax, tetay)
c
c         form direction cos. if tx, ty are large, not correct.
       call cvec2dcos(tetax, tetay, dircos)
c
c            new direction of moved particle in xyz system. 
       call ctransVectZ(MovedTrack.vec.w,   dircos, 
     *           MovedTrack.vec.w)
c     +++++++++++++++++++++++++++++++++++++++++++++++++++++++
c               displacement vector to direction cos
       call cdispVec2Dcos(dispx, dispy, leng, dircos)
c               in xyz system
       call ctransVectZ(MovedTrack.vec.w, dircos, dircos)

       do i = 1, 3
          MovedTrack.pos.xyz.r(i) = MovedTrack.pos.xyz.r(i)  +
     *         leng * dircos.r(i)
       enddo
       end

