cc       test cmoliere
c        implicit none
c        real*8 rho, zave, ave, z2ave, x0, mass
c        real*8 leng, teta, g1, g2, rl, e1, e2
c        integer i, z, cond, imax
c  
c        x0 =364.0
c        rho = .33
c        zave = 7.36
c        ave =14.75
c        z2ave = 53.5
c        mass = 106.d-3
c        read(*, *) imax, rl
c        z = 1
c        leng = rl*x0/rho
c  
c        e1 = 50.
c        e2 = e1 - rl * 80.d-3
c        g1 = e1/mass
c        g2 = e2/mass
c        do i =1 , imax
c           call cmoliere(rho, zave, z2ave, ave, 
c     * z, mass, g1, g2,  leng, teta, cond)
c          if(cond .ne. 0) then
c              write(0, *) 0.
c           else
c              write(*, *) sngl(teta**2)
c           endif
c        enddo
c        end
c
      subroutine cmoliere(rhoin, zin, z2in, ain,
     *           z, mass, g1, g2,  leng, teta, cond)
      implicit none
c        Moliere theory of multiple scattering angle.
c
      real*8 rhoin  ! input. average media density in kg/m^3
      real*8 zin    ! input. Mass weighted <Z> of the media 
      real*8 z2in   ! input. Mass weighted <Z^2> //
      real*8 ain    ! input. Mass weighted <A> //

      integer z  ! input.  charge of the particle is ze
      real*8 mass ! input.  mass of the particle in GeV
      real*8 g1  ! input.  gamma factor at the path head
      real*8 g2  ! input.  gamma factor at the path end
      real*8 leng ! input. length the charged particle travelled in m.      
      real*8 teta ! output. sampled spatial angle in radain.
      integer cond ! output. 0 ok. non-0. Moliere theory not applicable

      real*8  rho, zave, z2ave, aave, gbeta2, beta2, massratio2
      common /Zcmedia/ rho, zave, z2ave, aave, gbeta2, beta2,
     *       massratio2

c     *********************
      real*8 xc2, xa2, bp, b, u
      real*8 a0, a1, a2,  sum, ra2, ra2inv

      integer icon
      real*8 rejf1, rejf21, rejf22
      real*8 x
c       
c      rejection function for redueced angle < 1.8
c          x is suqre of reduced angle better than 0.2 %
       rejf1(x)= ((0.1217176d-01*x + 0.3054916d-01)*x -0.2524543d0)*x
     *          + 0.9990352d0          
c
c              at 0 < x = 1/angle^2 < 0.15
       rejf21(x) =(( -162.1568*x + 44.48334)*x + 0.3907116)*x 
     *      + 0.4399338              

c             at  x = 1/angle^2 > 0.15
       rejf22(x) = (( 71.23819*x - 49.61906)*x + 10.77501)*x+ 0.2001145      
c
c ------------------------------------

      rho = rhoin
      zave = zin
      z2ave = z2in
      aave = ain
      gbeta2=(g1 - 1.d0/g1) * (g2 - 1.d0/g2)
      beta2 = 1.d0 - 1.d0/g1/g2
      massratio2= (0.511d-3/mass)**2  ! (me/m)^2
c    ............................

c          get Xc^2
      call ckaic2(z,  leng,  xc2)
c          get Xa^2
      call ckaia2(z,  xa2)

c          b -log(b) = b'
      bp = log(xc2/xa2/1.167)

      if(bp .lt. 3.395) then
c         Moliere theory cannot be appliled; use Gaussian later (almost no scattering)
         cond = 1
      else
         cond = 0
         call cblogb(bp, b, icon)
         a0 = max(1.d0 - 5/b, 0.d0)  ! actually a0=0 dose not happen becasuse
c                                      the condtition above.
         icon = 1               ! make 0 if no rejection
c                the sampling function decomposition is explained in Test/....tex
         do while (icon .ne. 0)
            a1 = 5.21062/b
            a2 = 0.7128/b
            sum = a0 + a1 + a2
            call rndc(u)
            if(a0/sum  .gt. u) then
c             sample reduced angle from exp(-x) dx where x = reduced
c               angle^2.
               call rndc(u)
               ra2 = -log(u)
               icon = 0
            elseif( (a0+a1)/sum .gt. u) then
c            sample reduced angle from exp(-x) dx (same as above but
c                  in the region of ra < 1.8
               call rndc(u)
               ra2 = -log(1.-u/1.04076)
c                rejection function
               call rndc(u)
               if(u .lt. rejf1(ra2)) then
                  icon = 0
               endif
            else
c             sample reduced angle from 2xc2 x^-4dx
               call rndc(u)
               ra2 = 3.24/u
c               rejection function
               call rndc(u)
               ra2inv = 1./ra2
               if(ra2inv .lt. 0.15) then
                  if(u .lt. rejf21(ra2inv)) then
                     icon = 0
                  endif
               elseif(u .lt. rejf22(ra2inv)) then
                  icon = 0
               endif
            endif
         enddo
         teta =sqrt( ra2 * xc2 * b)
      endif
      end
c
c      real*8 z, aave, z2ave, rho, leng, g1, g2, xc2
c      z = 1.
c      aave = 207.
c      z2ave = 82*82
c      rho = 11.3 * 1.d-3/1.d-6
c      leng = .5d-2
c      g1 = 100./0.5
c      g2 = 99./0.5
c      call ckaic2(z, aave, z2ave, rho, leng, g1, g2, xc2)
c      write(*, *) xc2
c      end
c      real*8 c, b
c      integer cond
c      do c = 3., 20., 0.1
c         call cblogb(c, b, cond)
c         write(*,*) c, b
c      enddo
c      end
c     ***************************
      subroutine cblogb(c, b, cond)
      implicit none
c        solve  B - log(B) = c
c
      real*8 c ! input.   c>=1.
      real*8 b ! output.  solved b >=1. (b <1 is discarded)
      integer cond ! output. 0 if ok.
                   !         1 if c < 1.
      if(c .lt .1) then
         cond = 1
      else
c         b = 0.7 + 1.32 *c -  0.01451* c*c
          b =(((-0.3733404E-04*c + 0.1902303E-02)*c -0.3841290E-01 )*c
     *         + 1.431932)*c +     0.5200487 
      endif
      end
      subroutine ckaia2(z,   xa2)
      implicit none
c        compute Xa^2; assume the Xa^2 is weakly
c       dependent on Z, we use average Z=zave for
c       calculation.
c
      integer z  ! input. charge of the charged particle is ze
      real*8 xa2   !  output. Xa^2.

      real*8  rho, zave, z2ave, aave, gbeta2, beta2, massratio2
      common /Zcmedia/ rho, zave, z2ave, aave, gbeta2, beta2, 
     *       massratio2
      
      real*8   alpha, const, pi, large
      parameter (alpha = 1./137., const = (1.13*alpha)**2 )
      parameter (pi = 3.1415, large = (pi/2.)**2)

      if(gbeta2 .le. 0.) then
         xa2 = large
      else
         xa2 = const * zave**0.66666 * massratio2 *
     *   (1.13 * beta2 + 3.76*(alpha*z*zave)**2)
     *     /gbeta2
      endif
      end
c
      subroutine ckaic2(z, leng, xc2)
      implicit none
c
c   note: we neglect atomic electron contribution because it is
c         considered in Moller or Bhabha scattering.
c
c         compute Xc^2 = 4Pi r_0^2 N0 z^2 rho Z^2/A  * integral
c        0 to leng of 1/beta**4/gamma**2  (radian^2)/massratio2
c
      integer z     ! input. charged particle charge is ze.
      real*8 leng  ! input. length traveled by the charge particle in m
      real*8 xc2    ! output. Xc^2 in radian^2

      real*8  rho, zave, z2ave, aave, gbeta2, beta2, massratio2
      common /Zcmedia/ rho, zave, z2ave, aave, gbeta2, beta2,
     *       massratio2

      real*8 r0, avoganum, const, large, pi
      parameter (r0=2.817d-15, avoganum=6.022d23, pi= 3.1415)
      parameter (const = 4.*pi* r0**2 * avoganum*1.d3, 
     *    large = (pi/2)**2)
c
c
c      integeral 0 to leng of  1/(beta**4 E**2)
c      is approximated as  leng/(beta1**2 gamma1 beta2**2 gamma2)
c      Note: bata**2 *gamma = gamma - 1/gamma
c

      if(gbeta2 .le. 0.) then
         xc2 = large
      else
         xc2 = const* z* z * z2ave/aave * rho * leng/gbeta2
     *        * massratio2
      endif
      end
