c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*70  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*70  CutOffFile   !1  Geomagnetic cut-off file
	character*70  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is ../Data/.contInfo.  This will be created when job
                                   !   is finished normally.
	character*70  SkeletonFile !1  Skeleton information file  (full or relative path). created if  Job =
                                   !   'skeleton'. Default is ../Data/skeletonParam
                                   !   This is the Namelist data which should be used as input at the time of
                                   !   Job='flesh' after modifying parameters in &Param there.
	character*10  Job          !1  What kind of job you are going to do.
                                   !   =' ' (default).  nothing special.
                                   !   ='skeleton'.  Makes skeleton. Later you can add AS, follow particles
                                   !        to a lower energy and/or to a deeper depth, by giving Job='flesh'.
                                   !        'skeletonParm' is automatically created.
                                   !   ='flesh'. Using information created by Job='skeleton' and the 
                                   !             initial random number for each event, you can add AS,
                                   !             follow particles to a lower energy and/or to a deeper depth.
	                           !             The namelist parameters you give should be 'skeletonParam'
	                           !             with some necessary modification.
        character*70  SeedFile     !1  The path to a file name to contain the initial random numbers for each 
                                   !   event. If this is non-blank, the seeds are always writen in this file.
                                   !   If your job is skeleton making or fleshing, this must be given.
                                   !   Default is '../Data/seed'.
                                   !   This file is opened automatically.  This will help when a job
                                   !   crashes.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers.
	integer       EventNo      !2  cumulative event number counter.
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0

c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, 
     *  ErrorOut, Cont, InitRN(2), 
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


	common /Zmanagerpc2/ PrimaryFile,
     *  CutOffFile,  Job, ContFile,  
     *  SkeletonFile, SeedFile, DeadLine
