c         test cbremsPath, cbremsEnerg
c      implicit none
c      real*8  ee, eg, t
c      integer i
cc     write(0, *) " Enter electron energy in GeV"
c      read(*, *)  ee
c      do i =1, 10000
c         call cbremsPath(ee, t)
c         call cbremsEnergy(ee, eg)
c         write(*, *) sngl(t), sngl(eg), sngl(eg/ee)
c      enddo
c      end
c     ****************************************************************
c     *                                                              *
c     *      brems and pair in air.   Energy in GeV. path in r.l     *
c     *                                                              *
c     *  cbremsPath:  samples path for brems                          *
c     *  cbremsEnergy:  samples energy of brems gamma                 *
c     *                                                              *
c     ************ this is version for Egcut= 1 MeV in air ***********
c                  without Landau effect.
c
c
c      for e < 2 MeV, x-section of 2 MeV is used and eg is sampled by
c                    complete screening even if scorec=t.
c
c       use r.l=36.4 g/cm**2
c           critical energy=76 + 1 + (other collision loss such as
c                           bhaba and moller scat; if these cross-
c                           sections are not considered in the
c                           simulation)  (mev)
c       At higher energies,  use complete screening cross-section
c       with multiplication of .98 to match the correction to the Born
c       approximation. The complete screening x-section may be
c       used from >10 GeV region within a small error.  so that
c       dimension of the tables may be much small, and one can drop
c       last parts of each table.
c
c   ********************************************************************
c
c         sampling table for brems
c
c     Egcut of brems gamma ray is 1 MeV.  that is brems gamma less than
c     1 MeV does not generated by this table.  such low energy brems
c     should be treated as energy loss of electrons.  the energy loss
c     (about 1 MeV) may be included in critical energy.
c
c
c
c   /usage/          call cbremsPath(ee, t)
c                    call cbremsEnergy(ee, beg)
c
c      ee:  electron energy  GeV
c       t:  sampled path     r.l
c     beg:  sampled gamma energy  GeV
c
c          To call cbremsEnergy,cbremsPath must be called
c
c
      subroutine cbremsPath(ee, t)
      implicit none
      real*8 ee, t
c
c            table of total cross section of bremsing (eg > 1MeV
c     /r.l.   energy is from 2MeV to 200gev in step .3333 (log10 scale)
c
      integer i
      real*8 tcb(16)
c
c        let v be energy of produced ptcl/energy of incident ptcl
c        let u be uniform random no. in (0, 1).
c
c         2 dimen.  table of   ln(v/vmin)/ (1-u)  for brems
c      for u=0.1 to 1. step .1 and log10(e)=log10(2.e-3gev) to log10(200
c      gev)  step .3333    dimension is vb1(10,  16)
c                                            !for u    !for log10(e)
c
c      to sample eg by electron brems, 1st sample uniform random no. u.
c      if u>.1 use this table.  take log10(e) and use two dimensional
c      interpolation to get value(=y) of vb1 at given (u,log10(e)) and
c      set eg= e * vmin * exp((1-u)*y)= 1.e-3 * exp( (1.-u) * y)
c      (in gev)  (vmin =1.e-3/e;    1.e-3 = egcut in gev).
c
c
      real*8 emass/0.511e-3/

      real*8  vb1(160)
      real*8  evb1(10, 16)
      equivalence (evb1(1, 1), vb1(1))
c
c
c       2 deim. brems sampling table.
c         value of  ln(v/vmin)  from u=0 to .1 step .01 and e=2.e-3 gev
c         to 200gev as in vb1 (log10 scale).     dim.  vb2(11,16)
c         use this table if u<.1.
c         eg=e * vmin * exp(y) = 1.e-3 * exp(y)   (in gev)
c
      real*8 vb2(176)
      real*8 evb2(11, 16)
      equivalence(evb2(1,1),  vb2(1))
c
c
c        ecut:   predetermined cut-off energy for bremsung gamma=1 MeV.
      real*8  ecut/1.e-3/
c
c
      logical screen, scorec/.true./
c
c                 log 2.e-3
      real*8  ebmni/-2.698971/

      real*8 escb/10./
c
      real*8 rx0/0.98 /
      real*8 u, alu, eesv, vc, tp, a, v, beg, ans, ale

      data (tcb(i), i=   1,  16)/
     1 0.0993, 0.7040, 1.6923, 2.8352, 3.9962, 5.1318, 6.2375, 7.3193,
     2 8.3848, 9.4401,10.4892,11.5345,12.5778,13.6201,14.6618,15.7034/

      data (vb1   (i),i=   1,  72)/
     1 0.3643, 0.3436, 0.3286, 0.3163, 0.3062, 0.2976, 0.2899, 0.2833,
     2 0.2771, 0.2715, 1.1528, 1.0778, 1.0245, 0.9824, 0.9478, 0.9183,
     3 0.8926, 0.8696, 0.8467, 0.8302, 1.9069, 1.7917, 1.7110, 1.6497,
     4 1.6006, 1.5639, 1.5327, 1.5038, 1.4772, 1.4608, 2.6798, 2.5489,
     5 2.4614, 2.3951, 2.3449, 2.3040, 2.2724, 2.2453, 2.2235, 2.2048,
     6 3.4691, 3.3297, 3.2356, 3.1698, 3.1214, 3.0850, 3.0570, 3.0351,
     7 3.0181, 3.0038, 4.2566, 4.1078, 4.0133, 3.9501, 3.9062, 3.8750,
     8 3.8522, 3.8354, 3.8228, 3.8126, 5.0333, 4.8767, 4.7828, 4.7241,
     9 4.6855, 4.6593, 4.6411, 4.6289, 4.6199, 4.6132, 5.7983, 5.6352/
      data (vb1   (i),i=  73, 144)/
     1 5.5441, 5.4902, 5.4570, 5.4359, 5.4223, 5.4131, 5.4072, 5.4030,
     2 6.5536, 6.3866, 6.2998, 6.2516, 6.2238, 6.2072, 6.1970, 6.1907,
     3 6.1869, 6.1843, 7.3024, 7.1345, 7.0533, 7.0113, 6.9885, 6.9759,
     4 6.9684, 6.9642, 6.9619, 6.9601, 8.0484, 7.8818, 7.8070, 7.7707,
     5 7.7523, 7.7428, 7.7376, 7.7345, 7.7329, 7.7322, 8.7930, 8.6299,
     6 8.5616, 8.5308, 8.5160, 8.5090, 8.5054, 8.5034, 8.5023, 8.5020,
     7 9.5381, 9.3799, 9.3183, 9.2920, 9.2805, 9.2753, 9.2726, 9.2720,
     8 9.2713, 9.2707,10.2843,10.1319,10.0765,10.0545,10.0457,10.0417,
     910.0399,10.0393,10.0394,10.0388,11.0321,10.8860,10.8365,10.8183/
      data (vb1   (i),i= 145, 160)/
     110.8112,10.8083,10.8074,10.8066,10.8065,10.8065,11.7812,11.6420,
     211.5980,11.5827,11.5773,11.5756,11.5747,11.5744,11.5746,11.5742/

      data (vb2   (i),i=   1,  72)/
     1 0.3981, 0.3895, 0.3814, 0.3737, 0.3665, 0.3595, 0.3528, 0.3462,
     2 0.3400, 0.3338, 0.3278, 1.3344, 1.2746, 1.2358, 1.2037, 1.1750,
     3 1.1487, 1.1243, 1.1011, 1.0790, 1.0579, 1.0376, 2.1716, 2.0772,
     4 2.0214, 1.9738, 1.9307, 1.8906, 1.8528, 1.8166, 1.7819, 1.7486,
     5 1.7162, 2.9698, 2.8640, 2.7983, 2.7406, 2.6872, 2.6368, 2.5885,
     6 2.5421, 2.4973, 2.4538, 2.4119, 3.7513, 3.6442, 3.5729, 3.5080,
     7 3.4470, 3.3886, 3.3324, 3.2775, 3.2247, 3.1728, 3.1222, 4.5253,
     8 4.4203, 4.3448, 4.2745, 4.2069, 4.1412, 4.0768, 4.0136, 3.9517,
     9 3.8908, 3.8310, 5.2958, 5.1932, 5.1136, 5.0368, 4.9612, 4.8865/
      data (vb2   (i),i=  73, 144)/
     1 4.8129, 4.7403, 4.6691, 4.5988, 4.5300, 6.0647, 5.9632, 5.8771,
     2 5.7921, 5.7070, 5.6227, 5.5393, 5.4571, 5.3761, 5.2965, 5.2185,
     3 6.8328, 6.7296, 6.6354, 6.5406, 6.4454, 6.3507, 6.2569, 6.1648,
     4 6.0741, 5.9853, 5.8982, 7.6006, 7.4930, 7.3892, 7.2837, 7.1776,
     5 7.0721, 6.9679, 6.8659, 6.7658, 6.6679, 6.5722, 8.3683, 8.2540,
     6 8.1394, 8.0227, 7.9054, 7.7892, 7.6750, 7.5631, 7.4539, 7.3475,
     7 7.2436, 9.1359, 9.0132, 8.8875, 8.7591, 8.6306, 8.5037, 8.3795,
     8 8.2583, 8.1405, 8.0257, 7.9137, 9.9035, 9.7713, 9.6340, 9.4939,
     9 9.3541, 9.2168, 9.0829, 8.9528, 8.8266, 8.7039, 8.5843,10.6710/
      data (vb2   (i),i= 145, 176)/
     110.5285,10.3794,10.2276,10.0769, 9.9294, 9.7863, 9.6478, 9.5134,
     2 9.3829, 9.2559,11.4385,11.2853,11.1243,10.9609,10.7994,10.6422,
     310.4902,10.3433,10.2011,10.0631, 9.9288,12.2061,12.0418,11.8688,
     411.6939,11.5220,11.3554,11.1947,11.0398,10.8900,10.7446,10.6031/

      save tp, screen, ale

c
c       rx0=x0(true)/x0(in nishimura text)
c
      if(.not. scorec  .or.  ee .gt. escb) then
c            complete screening cross-section
          screen=.false.
          vc=ecut/ee
          tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
      else
c             partial screening: for low energy e, use 2MeV x-section
          if(ee .gt. 2.e-3) then
               screen=.true.
               eesv=ee
          else
               screen=.false.
               eesv=2.e-3
          endif
          ale=log10(eesv)
          call kintp3(tcb, 1, 16,  ebmni, .333333d0,  ale, tp)
      endif
      call rndc(u)
      alu=-log(u)
      t= alu/tp
      return
c
c     ************
      entry cbremsEnergy(ee, beg)
c     ************
c
      call rndc(u)
      if(.not. screen) then
c            complete screening
          a=u*tp
          if(a .lt. 1.) then
              v=exp(-a)
              if(a  .gt. .1) then
                  v=((.06366*a-.1447407)*a+1.014176)*v
              endif
          else
              v=exp(-(a+0.8603)/1.3603)
              if(a .lt. 6.) then
                   v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a
     *             -.684076)*a +1.841734)*v
              endif
          endif
          beg=ee*v
      else
c            partial screening
          if(u .gt. 0.1) then
               call  k4ptdi(evb1, 10, 16, 10, 0.1d0, ebmni,.1d0, 
     *         .3333333d0,  u, ale, ans)
               beg=exp(ans*(1.-u))* ecut
          else
               call  k4ptdi(evb2, 11, 16, 11, 0.d0, ebmni, .01d0,
     *         .3333333d0,   u, ale, ans)
               beg = exp(ans) * ecut
          endif
      endif
      if(ee - beg .le. emass) then
         beg =( ee -emass )* 0.9999
      endif
      end
