cc------------------- test cp_p2p_Axs ----------------------------
c     implicit none
c     real*8 a, xsxp, xsxa
c     integer ia, is
c     do  ia=10, 207, 10
c         a=ia
c         do    is=1, 40
c             xsxp=1.d-2*10.**( (is-1)/10.)
c             call cxp2xAXsec(a, xsxp, xsxa)
c             write(*, *) sngl(xsxp), sngl(xsxa)
c         enddo
c         write(*,*)
c     enddo 
c     end
c ****************************** cp_p2p_Axs
c          convert xp inelastic x-section into x-A inelastic xs.
        subroutine cxp2xAXsec(a, xsxp, xsxa)
c
c    a: real*8. input.  Mass # of the target
c   xsxp: real*8. input.  x-section of xp   (mb)
c   xsxa: real*8. output. x-section of xA   (mb)
c
        implicit none
        real*8  a, xsxp, xsxa
c
        real*8 b, e, alfa
        if(xsxp .lt. 1.) then
            xsxa=xsxp*a
        else
            if(xsxp .ge. 30.)then
                b=.462
            else
                b=.693
            endif
            e=xsxp/30. -1.
            if(abs(e) .lt. .2) then
                xsxa=253. * (1. + b*e + b*(b-1.)*e/2)
            else
                xsxa=253. * (xsxp/30.)**b
            endif
            if(a .ne. 14.5d0) then
                alfa=min(1.d0, .725d0*(xsxp/30.d0)**(-.153d0) )
                xsxa=xsxa* (a/14.5)**alfa
            endif
            if(xsxp .lt. 10.) then
                xsxa=min(xsxp*a, xsxa)
            endif
            xsxa=max(xsxa, xsxp)
        endif
      end
