c     this is a trial to suppress very large x part by making an
c     intermediate routine chncol2 which is the original chncol.
c     And on top of it, chncol is made.
c     *****************************************************************
c     *                                                               *
c     * chncol: hadron nucleon collision
c     *                                                               *
c     *****************************************************************

       subroutine chncol(pj, tg, a, ntp, icon)
c             pj:  structure /ptcl/. Input. to give the incident
c     projectile hadron in the Lab. system.
c             tg:  structure /ptcl/. Input. to give the target
c                  nucleon in the Lab. system.
c              a:  array of structure /ptcl/. Output. to get
c                  produced particles.
c            ntp:  integer. Output. to get the total number of produced
c                  particles in a.
c           icon:  Integer. Output. if 0, particle generation is ok
c                   if non 0, you may give up generation.
c
c                 Note: target recoil is put in a(ntp-1),
c                       projectile recoil is put in a(ntp)
c
       implicit none

#include  "Zptcl.h"
#include  "Zevhnv.h"
c
c
       record /ptcl/ pj, tg,  a(*)
       integer ntp, icon
       integer i
       real*8 u, xmax

c       real*8 BigXRejCnst/1./, BigXRejPw/2./
       real*8 BigXRejCnst/.4/, BigXRejPw/2.2/
       do while (.true.)
          call chncol2(pj, tg, a, ntp, icon)
          if(icon .ne. 0) goto 100
c             find max secondary energy.
          xmax = 0.
          do i = 1, ntp-2
             if(xmax .lt. a(i).fm.p(4)) xmax = a(i).fm.p(4)
          enddo
          xmax = xmax/pj.fm.p(4)
c              if very large x appears, discard it
c              with some probabilty to adjust
c              the x-distribution.
          call rndc(u)
          if(u  .lt. 
     *       (  BigXRejCnst/(BigXRejCnst +
     *           (xmax/(1.0-xmax))**BigXRejPw) ) )  goto 100
       enddo
 100   continue
       end

c     *****************************************************************
c     *                                                               *
c     * chncol2: hadron nucleon collision
c     *                                                               *
c     *****************************************************************
c
c

       subroutine chncol2(pj, tg, a, ntp, icon)
c             pj:  structure /ptcl/. Input. to give the incident
c                  projectile hadron in the Lab. system.
c             tg:  structure /ptcl/. Input. to give the target
c                  nucleon in the Lab. system.
c              a:  array of structure /ptcl/. Output. to get
c                  produced particles.
c            ntp:  integer. Output. to get the total number of produced
c                  particles in a.
c           icon:  Integer. Output. if 0, particle generation is ok
c                   if non 0, you may give up generation.
c
c                 Note: target recoil is put in a(ntp-1),
c                       projectile recoil is put in a(ntp)
c
       implicit none

#include  "Zptcl.h"
#include  "Zevhnv.h"
c
c
       record /ptcl/ pj, tg,  a(*)
       integer ntp, icon, jcon, nfin
       integer i
       record /ptcl/ pjin
c         use pt=0 incident
      pjin = pj
      pjin.fm.p(1) = 0.
      pjin.fm.p(2) = 0.
      pjin.fm.p(3) = sqrt(pjin.fm.p(4)**2 - pjin.mass**2)
c

c        *** until loop**until succeed
      do while (.true.)
c            generate 2 leading ptcls  Zevhnv become ready for use.
          call cs2lp(pjin, tg, icon)
          if(icon .ne. 0) then
c              neglect this event; because of very low energy
c              no particle can be produced
               ntp = 0
              jcon = 0
          else
c               generation of  particles other than the leadings.
              call cgnlp(a, ntp, jcon)
          endif

          if(jcon .eq. 0 ) goto 10
       enddo   
   10 continue
c           ptcls in 'a' should have cms energy, here.
c           give final ptcl charge/ subcode for 
c           pi+-,  k0,k0~,k+,k-
      call cpikcd(a, ntp)
c              boost  to lab system
      do   i=1, ntp
         call cibst1(i, Cmsp, a(i), a(i))
      enddo
c          decay of "composit ptcls" (nn~, dd~)
      call cdcycp(a, ntp, nfin)
      ntp=nfin
c            store recoils in a
      a(ntp+1) = Rtglab
      a(ntp+2) = Rpjlab
      ntp = ntp +2
c       -------------- rotate 
      call crot3mom(pj, a, ntp)
      end
c      ****************************************************
c           decay of nn~  or  DD~ in the projectile system
       subroutine cdcycp(a, nin, n)
c      ****************************************************
       implicit none
c----       include  '../../Zptcl.h'
#include  "Zptcl.h"
c----       include '../../Zcode.h'
#include  "Zcode.h"
       integer nin, n
       record /ptcl/ a(*)
       integer i, k, nx
       record /ptcl/ p(2)
          n=nin
          do i=1, nin
             k=a(i).code
             if(k .eq. knnb .or. k .eq. kddb) then
                 if(k .eq. knnb) then
                     call cnnbdc(a(i), p, nx)
                 elseif(k .eq. kddb) then
                     call cddbdc(a(i), p, nx)
                 endif
c                 put n or D in the i-th pos. and append c antiptcl 
c                 at the bottome and increase n
                 a(i) = p(1)
                 a(n +1 ) = p(2)
                 n=n+1
             endif    
          enddo
      end
c ******************************************************* 
c       give final ptcl code for pi+,-, k0,k0~,k+,k-
      subroutine cpikcd(a, ntp) 
c
c*******************************************************
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"
c----      include '../Zevhnv.h'
#include  "Zevhnv.h"
      integer ntp
      record /ptcl/  a(ntp) 
c
      integer i, k
      real*8 x
        if(ntp .eq. 1) then
c              nothing to do. charge assignment should have
c              been done in c1pion
        else
             do i=1, ntp
                x = a(i).fm.p(3)/Pjcms.fm.p(3)
                k = a(i).code
                if(k .eq. kpion .and. a(i).charge .ne. 0) then
                     if(x .gt. 0.) then
                         call cspipm(Pjcms, x, a(i))
                     else
                         call cspipm(Tgcms, -x, a(i))
                     endif
                elseif(k .eq. kkaon) then 
c                            set kaon charge
                     if(x .gt. 0.) then
                        call cskchg(Pjcms, x, a(i))
                     else
                        call cskchg(Tgcms, -x, a(i))
                     endif
                endif
             enddo
        endif
      end 
c   ******************************************************* 
c         nn~ decay.  
c        a: projectile.  b: decay product 
c   *******************************************************
      subroutine cnnbdc(a, b, n)
      implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
c----       include '../../Zcode.h'
#include  "Zcode.h"
       integer n
       record /ptcl/ a, b(2) 
c
       integer ic
       real*8 u 
c
         call rndc(u)
         ic=u*2         ! charge
         if(ic .eq. 0) then
             call cmkptc(knuc,  kneutron, ic,   b(1))
             call cmkptc(knuc,  kneutronb, -ic,  b(2))
         else    
             call cmkptc(knuc, 0, ic,  b(1))
             call cmkptc(knuc, 0, -ic, b(2))
         endif    
         call c2bdcy(a, b(1), b(2))
         n=2
      end 
c ******************************************************* 
c       decay of (dd~) 
c       a: parent.  b: decay product
c *******************************************************
      subroutine cddbdc(a, b, n)
      implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
c----       include '../../Zcode.h'
#include  "Zcode.h"
       integer n
       record /ptcl/ a, b(2) 
c
       integer ic
       real*8 u 
c
         call rndc(u)
         ic=int(u*3)-1 ! charge
         if(ic .eq. 0) then
             call cmkptc(kdmes,  kd0, ic,  b(1))
             call cmkptc(kdmes,  kd0b, -ic, b(2))
         else    
             call cmkptc(kdmes,  0, ic,  b(1))
             call cmkptc(kdmes,  0, -ic,  b(2))
         endif
         call c2bdcy(a, b(1), b(2))
         n=2
      end 
c***************************************************************** 
c  cspipm: set pi+/pi- 
c
c***************************************************************** 
c the ratio npi+/npi- for p incident case is
c       1+b*x with b=3.5 (x<.6) and 3.1exp(4.4(x-.6)) (x>.6)
c       if  the ratio,   pi+/pi- = f(x),
c          prob of pi+ = (f/(1+f))

       subroutine cspipm(pj, x, a)

       implicit none

#include  "Zptcl.h"
#include  "Zcode.h"

       record /ptcl/ pj, a
       real*8 x
c
       real*8 f, up, u
c
         if(x .lt. .6d0) then
             f = 1.d0+3.33d0*x
         else
             f = 3.0d0* exp( 4.4d0*(x-.6d0))
         endif
         if(pj.charge .eq. 1) then
             up=f/(1.d0+f)
         elseif(pj.charge .eq. -1) then
             up=1.d0/(1.d0+f)
         else
             if(pj.subcode .eq. 0) then
                 up=0.5
             elseif(pj.subcode .eq. regptcl) then
                 up=1.d0/(1.d0+f)
             else
                 up=f/(1.d0+f)
             endif
         endif
         call rndc(u)
         if(u .lt. up) then
              a.charge = 1
              a.subcode = regptcl
         else
              a.charge = -1
              a.subcode = antip
         endif
      end
c     ************************************************
c           set kaon charge/subcode
      subroutine cskchg(pj, x, a)
c     ************************************************
      implicit none

#include  "Zptcl.h"
#include  "Zcode.h"

      record /ptcl/ pj, a
      real*8 x
c
      real*8 f, u, up
       if(a.charge .ne. 0) then
c             k+/k- for p incident
           if(x .lt. .3d0) then
              f=exp(4.36d0*x)
           elseif(x .lt. .6d0) then
              f=3.7d0*exp(6.5d0*(x-.3d0))
           else
              f=27.d0*exp(11.3d0*(x-.6d0))
           endif
           if(pj.charge .eq. 1) then
              up=f/(1.d0+f)
           elseif(pj.charge .eq. -1) then
              up=1./(1.d0+f)
           else
              if(pj.subcode .eq. 0) then
                 up=0.5d0
              elseif(pj.subcode .eq. regptcl) then
                 up=1.d0/(1.d0+f)
              else
                 up=f/(1.d0+f)
              endif
           endif
           call rndc(u)
           if(u .lt. up) then
               call cmkptc(kkaon, 0, 1,  a)
           else
               call cmkptc(kkaon, 0,  -1,  a)
           endif
       else
c            k0
           call rndc(u)
           if(u .lt. .50d0) then
              call rndc(u)
              if(u .lt. 0.5) then
c                 k0 short
                 call cmkptc(kkaon, k0s, 0,  a)
              else
                 call cmkptc(kkaon, -k0s, 0,  a)
              endif
           else
              call rndc(u)
              if(u .lt. 0.5) then
                 call cmkptc(kkaon, k0l, 0, a)
              else
                 call cmkptc(kkaon, -k0l, 0, a)
              endif
           endif
       endif
      end
