c      ****************************************************** 
       subroutine cgrap(w,  ptav, ntp,  a, icon)
c          generation of rapidity for mass missing. mass
c      ****************************************************** 
       implicit none
c----       include  '../../Zptcl.h'
#include  "Zptcl.h"
       integer ntp, icon
       record /ptcl/ a(ntp)
       real*8  ptav, w   ! w is missing mass
c
       integer i, maxi, mini
       real*8 y, z
c                 sample proto-rapidity
         call cprap(ptav,  a,  ntp)
c                 normalize proto-rapidity to 0 to 1.
         call cnprap(a, ntp, maxi, mini)
c                 compute transverse mass.(note; save in pt pos.)
         do   i=1, ntp
c              a(i).fm.tm= sqrt(a(i).mass**2 + a(i).fm.p(3)**2)
              a(i).fm.p(3)= sqrt(a(i).mass**2 + a(i).fm.p(3)**2)
         enddo
c              get coef. for y and z to modify rapidity
c              to conserve 4 momenta.
         call ccmrap(w, a, ntp, maxi, mini, y, z, icon)
         if(icon .eq. 0) then
c               convert to true rapidity satisfing 4 mom.
c               conservation.
             call cctrap(a, ntp, y, z)
c            ____________________________________________________
c                         check conservation
c            call cccrap(a,  ntp, sume, sump)
c            write(*,*) ' sume=',sume,' m  =',pj.mass,  ' sump=',sump
c            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
         endif
       end
c      *******************************************************
       subroutine cctrap(g, n, y, z)
c           convert rapidity into true rapidity satisfing e-p
c           conservation.
c      *******************************************************
       implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ g(n)
       real*8 y, z
c       
       integer i
c
          do   i=1, n
c               g(i).fm.rap = g(i).fm.rap*y + z
               g(i).fm.p(4) = g(i).fm.p(4)*y + z
          enddo
       end
c      *******************************************************
       subroutine cccrap(g,  n, sume, sump)
c                 check conservation
c      *******************************************************
       implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ g(n)
       real*8 sume, sump
c
       integer i
       real*8 yr
c
        sume=0.d0
        sump=0.d0
        do   i=1, n
c               yr=g(i).fm.rap
                yr=g(i).fm.p(4)
c               sume=sume+ cosh(yr)*g(i).fm.tm
c               sump=sump+ sinh(yr)*g(i).fm.tm
               sume=sume+ cosh(yr)*g(i).fm.p(3)
               sump=sump+ sinh(yr)*g(i).fm.p(3)
        enddo
       end
c      *********************************************
       subroutine cnprap(g,  n, maxi, mini)
c            normalize proto-rapidity in 0 to 1       
c      *********************************************
c       g(n): /ptcl/ Input.  g(i).fm.rap has y and
c             is normalized to have values in (0, 1.0).
c             the max value becomes 1.0 and the minimum one 0.0
c         n : integer Input. # of ptcls in g
c       maxi: integer. Output. g(maxi).fm.rap has  max y(=1)
c       mini: integer. Output. g(mini).fm.rap has  min y(=0)
c
       implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
       integer n, maxi, mini
       record /ptcl/ g(n)
c
       integer i
       real*8 gmx, gmn
       maxi=1
       mini=1
       do   i=1, n
c          if(g(i).fm.rap .gt. g(maxi).fm.rap ) maxi=i
          if(g(i).fm.p(4) .gt. g(maxi).fm.p(4) ) maxi=i
c          if(g(i).fm.rap .lt. g(mini).fm.rap ) mini=i
          if(g(i).fm.p(4) .lt. g(mini).fm.p(4) ) mini=i
       enddo
c       gmx=g(maxi).fm.rap
c       gmn=g(mini).fm.rap
       gmx=g(maxi).fm.p(4)
       gmn=g(mini).fm.p(4)
       do   i=1, n
c          g(i).fm.rap = (g(i).fm.rap - gmn )/(gmx-gmn)
          g(i).fm.p(4) = (g(i).fm.p(4) - gmn )/(gmx-gmn)
       enddo
      end
       subroutine ccmrap(w,  g,  n, maxi, mini, y, z, icon)
c        get coefficients y and z to modify rapidities so that
c        the total energy and pz should be conserved.
c
c
c       w: real*8. input.  available energy
c    g(n): /ptcl/  input.  g(i).fm.tm and g(i).fm.rap are used.
c       n: integer. input.  number of particles
c    maxi: integer. input. g(maxi).fm.rap is the max y
c    mini: integer. input. g(mini).fm.rap is the min y
c       y: real*8   output. coefficient in rap <- z + y* rap'
c                   where rap is the true rapidity which
c                   satisfy the energy-momentum conservation.
c       z: real*8   output. coefficient in rap <- z + y* rap'
c    icon: integer  output. 0--> o.k
c                           1--> n.g. retry
c  see. cpc. vol9. (1975). 297 by Jadach.
c
c          function to be solved for y is  symmetric around y=0
c          and has a form like  f(y)= c - y**2 ( c> 0)
c          (y > 0 is obtained as a solution)
c          in some stragne input, c becomes <0 with no solution
        implicit none
c----        include '../../Zptcl.h'
#include  "Zptcl.h"
        integer n, icon
        record /ptcl/ g(n)
c
        real*8 w, y, z
        integer maxi, mini
c
        real*8 eps1/0.0010d0/, w2, alw2, y1, epsx
        real*8 sump, summ, sumgp, sumgm, tmp
        real*8 expgyp, expgym, fy1, fy1p, dy, eps
        integer lp, i
c
         w2=w*w
         alw2=log(w2)
c         y1=log(w2/g(maxi).fm.tm/g(mini).fm.tm)
         y1=log(w2/g(maxi).fm.p(3)/g(mini).fm.p(3))
         epsx=eps1/sqrt(dble(n))
c
         lp=0
c         *** until loop*** 
         do while (.true.)
              lp=lp+1
              y = y1
              sump=0.
              summ=0.
              sumgp=0.
              sumgm=0.
              do   i=1, n
c                  tmp=g(i).fm.rap*y
                  tmp=g(i).fm.p(4)*y
                  if(tmp .gt. 100.d0 .or. 
     *                  tmp .lt. -100.d0) then
c                        no solution case: c < 0
                      lp=100
                      goto 100
                  else

                      expgyp=exp(tmp)
                      expgym=1.d0/expgyp
c                      sump = sump+ g(i).fm.tm*expgyp
c                      summ = summ+ g(i).fm.tm*expgym
                      sump = sump+ g(i).fm.p(3)*expgyp
                      summ = summ+ g(i).fm.p(3)*expgym
                      sumgp = sumgp +
c     *                     g(i).fm.tm*g(i).fm.rap*expgyp
     *                     g(i).fm.p(3)*g(i).fm.p(4)*expgyp
                      sumgm=sumgm +
c     *                     g(i).fm.tm*g(i).fm.rap*expgym
     *                     g(i).fm.p(3)*g(i).fm.p(4)*expgym
                  endif
               enddo

              fy1=alw2 -log(sump*summ)
              fy1p= - sumgp/sump + sumgm/summ
              dy =fy1/fy1p
              y1=y- dy
              eps=dy/y1
              if(abs(eps) .lt. epsx .or. lp .gt. 10) goto 100
         enddo
  100    continue
         if(lp .gt. 10) then
             icon=1
         else
             icon=0
             y=y1
             z=log(w/sump)
         endif
       end
c      *************************************
       subroutine cprap(ptav, pc, n)
c      *************************************
c            generate n proto-rapidities
c   ptav: real*8. input. avarage pt of this event
c  pc(n): /ptcl/  input/output. pc(i).fm.rap is created.
c      n: input. # of particles
c
c
c
       implicit none
c----       include  '../../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ pc(n)
       real*8 ptav
c
       integer i
       real*8 y, b
c
       do   i=1, n
c             b=(pc(i).fm.p(3)/ptav)**(-0.1) * 1.5   ! goot at 900 GeV

c             b=(pc(i).fm.p(3)/ptav)**(-0.2) * 1.5  !  goot at 900 GeV
c             b=(pc(i).fm.p(3)/0.3)**(-0.2) * 0.5   ! good at 200 GeV !
c              this  simple one is best.!!!
c             b= 1.  !  good at almost every where
             b = 1.0
             call cprap0(b, y)
c             pc(i).fm.rap = y
             pc(i).fm.p(4) = y
       enddo
       end
c     ***************************
       subroutine cprap0(a, y)
c         proto rapidity sampling
c     ***************************
       implicit none
       real*8 a, y
c
c             !
c           1 !*********!
c             !         !  *
c             !         !    *
c             !         !      *
c             !         !        *
c             !         !          *
c             0~~~~~~~~~1~~~~~~~~~~a+1
c
       real*8 s, u
          s=1.+a/2
          call rndc(u)
          if(u .lt. 1.d0/s) then
             call rndc(u)
             y=2*u-1.d0
          else
             call rndc(u)
             y=a*(1.d0 -sqrt(u)) + 1.d0
             call rndc(u)
             if(u .lt. 0.5d0) then
                y=-y
             endif
          endif
       end
