c       ****************************************************************
c       *
c       * csNeumuEMu:  sample energy of muon neutrino from mu decay
c       *
c       **************************tested 88.07.26***************k.k*****
c
c /usage/      call csNeumuEMu(f)
c   f: output. real*8.  sampled fractional energy.  f is the
c                       fraction  given by f=2*e'/m  where e' is the
c                       energy in muon rest system and m the muon mass.
c
        subroutine csNeumuEMu(f)
          implicit none
          real*8 f, f0
          integer l, i
c             f for u=0 to 1 step .01
      real*8 fa2(101), u
      data (fa2   (i),i=   1,  72)/
     1 0.0000, 0.1762, 0.2241, 0.2582, 0.2857, 0.3092, 0.3300, 0.3486,
     2 0.3658, 0.3817, 0.3965, 0.4106, 0.4238, 0.4364, 0.4485, 0.4601,
     3 0.4712, 0.4820, 0.4924, 0.5025, 0.5122, 0.5218, 0.5310, 0.5401,
     4 0.5489, 0.5575, 0.5660, 0.5742, 0.5823, 0.5903, 0.5981, 0.6058,
     5 0.6134, 0.6208, 0.6281, 0.6353, 0.6424, 0.6495, 0.6564, 0.6632,
     6 0.6700, 0.6766, 0.6832, 0.6898, 0.6962, 0.7026, 0.7089, 0.7152,
     7 0.7214, 0.7275, 0.7336, 0.7396, 0.7456, 0.7516, 0.7575, 0.7633,
     8 0.7691, 0.7749, 0.7806, 0.7863, 0.7919, 0.7975, 0.8031, 0.8087,
     9 0.8142, 0.8197, 0.8251, 0.8305, 0.8359, 0.8413, 0.8467, 0.8520/
      data (fa2   (i),i=  73, 101)/
     1 0.8573, 0.8626, 0.8678, 0.8731, 0.8783, 0.8835, 0.8887, 0.8939,
     2 0.8990, 0.9042, 0.9093, 0.9144, 0.9195, 0.9246, 0.9297, 0.9347,
     3 0.9398, 0.9448, 0.9499, 0.9549, 0.9599, 0.9650, 0.9700, 0.9750,
     4 0.9800, 0.9850, 0.9900, 0.9950, 1.0000/
c
          call rndc(u)
          if(u .lt. .01) then
              f0=0
              do   i=1, 2
                f0=((u+f0**4)/2)**.333333
              enddo
              f=f0
          else
              l=u*100.+1
              f=(fa2(l+1)-fa2(l))*100.*(u-(l-1)/100.) + fa2(l)
          endif
       end
