c----------------------------------------------------
c       cmkptc:  make  a particle
c        
c     implicit none
c     include '../Zptcl.h'
c     include '../Zcode.h'
c     record /ptcl/  p
c     integer i
c     do i=1, klast
c        call cmkptc(i, 0, 0,  p)
c        write(*, *) p.mass, p.charge
c     enddo
c     end   
      subroutine cmkptc(code, subcode,  charge, p)
c             make a particle. 
c       code: integer. Input. Particle code defined by the Cosmos convention.
c    subcode: integer. Input. Particle subcode defined //
c                      It has meaning for k0. neutron, gamma.
c     charge: integer. Input. Charge of the particle.
c                             In case of heavy (alpha, etd) this should be
c                             1 or -1, indepndently of the real charge.
c                             -1 for anti-neucleus.
c          p: structure /ptcl/. Output.
c                             Template particle is set.
c                  The attributes set are:
c                       px=undef  unchaged
c                       py=   //
c                       pz=   //
c                       e=    //
c                       mass=ptcl mass 
c                       code=ptcl code (same as input)
c                       subcode = ptcl sub code 
c                              This code is mainly used to identify
c                              particle/antiparticle.  If it is not
c                              important, or it is to be determined
c                              later, the user may give 0.
c
c                              This has meaning for the following
c                              particles. For other particles, 
c                              giving 0 is ok. It can be composed by
c                              'code' and 'charge'.
c----------------------------------------------------------------------
c                n           n~         k0s           k0l
c subcode
c defined      kneutron   kneutronb     k0s           k0l   
c in Zcode.h 
c----------------------------------------------------------------------
c           neutrino(e)  neutrino(mu)  neutrino(e)~   neutrino(mu)~
c
c subcode      regptcl            regptcl     antip          antip
c
c----------------------------------------------------------------------
c           direct gamma   brems gamma     d0          d0~
c
c subcode     kdirectg     kcasg          kd0          kdb
c
c----------------------------------------------------------------------
c                       charge=charge (if not heavy neuclus)
c                                     (charge * Z) (charge = 1, 0, -1)
c
c                             If subcode = 0 for  neutral partilces, this
c                             should be reset later, if they are
c                             not symmetric particle (k0, n, d0)
c              
c    
c                 
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
c----       include '../Zcode.h'
#include  "Zcode.h"
       record /ptcl/ p
       integer code, charge, subcode
c
          p.code = code
          if(code .ge. kdeut .and. code .le. khvymax) then
              call cshvc(code, charge, p)
          elseif(code .eq. ktriton) then
              call cshvc(code, charge, p)
          else
              p.charge = charge
          endif
          call csmass(code, charge, p)
          call cssubc(code, subcode, charge, p)
      end
c     *******************************************************
      subroutine csmass(code, charge, p)
c          set  particle mass from ptcl code and charge.
c            code: Integer. Input. partcle code defined in COSMOS
c           charge:Integer. Input. partcle charge.
c                p:/ptcl/  Output.  p.mass will get partcle mass in GeV.
c                           For heavy neucleus, (massp + massn)/2*A
c                           is used.
      implicit none
c----      include '../Zptcl.h'
#include  "Zptcl.h"
c----      include '../Zcode.h'
#include  "Zcode.h"
c----      include '../Zmass.h'
#include  "Zmass.h"
c
       integer code, charge
       record /ptcl/ p
c
       real*8 x
       parameter (x = 1.d50)
       real*8 mass(0:klast, -1:1)
       character*8 id
       integer massn
       character*70  msg
c
       data 
     * mass(kphoton, -1)/x/, mass(kphoton, 0)/0./,
     * mass(kphoton, 1)/x/,
     * mass(kelec,-1)/masele/,mass(kelec, 0)/x/,
     * mass(kelec, 1)/masele/,
     * mass(kmuon, -1)/masmu/,mass(kmuon, 0)/x/,
     * mass(kmuon, 1)/masmu/, 
     * mass(kpion, -1)/maspic/,mass(kpion, 0)/maspi0/,
     * mass(kpion, 1)/maspic/
       data
     * mass(kkaon, -1)/maskc/,mass(kkaon, 0)/mask0/,
     * mass(kkaon, 1)/maskc/,
     * mass(knuc, -1)/masp/, mass(knuc, 0)/masn/, 
     * mass(knuc, 1)/masp/,
     * mass(kneue, -1)/x/, mass(kneue, 0)/0./, 
     * mass(kneue, 1)/x/,
     * mass(kneumu,-1)/x/, mass(kneumu, 0)/0./, 
     * mass(kneumu, 1)/x/,
     * mass(knnb,  -1)/x/, mass(knnb, 0)/masnnb/,
     * mass(knnb, 1)/x/
       data
     * mass(kddb, -1)/x/, mass(kddb, 0)/masddb/,
     * mass(kddb, 1)/x/,
     * mass(kdmes, -1)/masd/, mass(kdmes, 0)/masd/, 
     * mass(kdmes, 1)/masd/,
     * mass(krho, -1)/masrho/,  mass(krho, 0)/masrho/,
     * mass(krho, 1)/masrho/,
     * mass(komega, -1)/x/,mass(komega, 0)/masomg/,
     * mass(komega,1)/x/,
     * mass(kphi, -1)/x/, mass(kphi, 0)/masphi/, 
     * mass(kphi, 1)/x/,
     * mass(keta, -1)/x/, mass(keta, 0)/maseta/,
     * mass(keta, 1)/x/ 
       data
     * mass(ksigma, -1)/massigmam/, mass(ksigma, 0)/massigma0/,
     * mass(ksigma, 1) /massigmap/,
     * mass(kgzai, -1) /masgzaim/, mass(kgzai, 0)/masgzai0/,
     * mass(kgzai, 1) /masgzaim/,
     * mass(klambda, 0)/maslambda/, mass(klambda, -1)/x/,
     * mass(klambda, 1)/x/,
     * mass(klambdac,-1)/x/, mass(klambdac, 0)/maslambdac/,
     * mass(klambdac, 1)/x/
     * mass(krare, -1)/0./, mass(krare,0)/0./, mass(krare,1)/0./

c

 
       if(code .ge. kdeut .and. code .le. khvymax) then
c                  get mass number
          call cghvm(code, massn)
          p.mass =( masn + masp)  * massn /2
       elseif(code .eq. ktriton) then
          p.mass = (masn *2 + masp)
       elseif(code .ge. 0 .and. code .le. klast) then
            p.mass = mass(code, charge)
            if(p.mass .eq. x) then
               call cgpid(code, id)
               write(msg, *)
     *        ' charge=',charge,' invalid for csmass; code=',id
               call cerrorMsg(msg, 0)
            endif
       else
            write(msg, *) ' code=',code,' invalid to csmass'
            call cerrorMsg(msg, 0)
       endif
      end
c     *******************************************************
      subroutine cssubc(code, subcode, charge, p)
c            set particle or anti particle subcode from 
c            ptcl code and charge.
c            code: Integer. Input. particle code defined in COSMOS
c          subcode: Integer. Input. paricle sub code //
c          charge:Integer. Input. partcle charge.
c             p: /ptcl/. Output. for most of particles,
c                        'ptcl' or 'antip' is set according to
c                        code and charge. For neutron, k0, gamma
c                        they are treated specially.
c                        for self conjugate particles, 0 is set.
c
      implicit none
c----      include '../Zptcl.h'
#include  "Zptcl.h"
c----      include '../Zcode.h'
#include  "Zcode.h"
c
       integer code, subcode, charge
       record /ptcl/ p
       character*70  msg
c
       if(code .ge. 1 .and. code .le. klast) then
c                   this should be consistent with regptcl/antip
c                   def. in Zcode.h
          if(code .eq. kphoton) then
             p.subcode = subcode
          elseif(code .eq. kelec .or. code .eq. kmuon ) then
             p.subcode = - charge * regptcl
          elseif(code .eq. kpion .or. code .eq. kkaon
     *            .or. code .eq. knuc) then
             p.subcode =  charge * regptcl
             if( code .eq. kkaon .and. charge .eq. 0 .and.
     *            subcode .ne. 0) then
                if(abs(subcode) .eq. k0s .or. 
     *               abs(subcode) .eq. k0l ) then
                   p.subcode = subcode
                else
                   write(msg,*) '1 strange subcode=', 
     *                  subcode,' to cssubc. code=', code
                   p.mass = -1.0
                   p.mass = sqrt(p.mass)
                   call cerrorMsg(msg, 0)
                endif
             elseif(code .eq. knuc .and. charge .eq. 0 
     *               .and.   subcode .ne. 0) then
                if(subcode .eq. kneutron .or.
     *               subcode .eq. kneutronb) then
                   p.subcode = subcode
                else
                   write(msg, *) '2 strange subcode=', 
     *                  subcode, ' to cssubc. code=', code
                   call cerrorMsg(msg, 0)
                endif
             endif
          elseif(code .eq. kdmes) then
             if(subcode .ne. 0 .and. charge .eq. 0)then
                if(subcode .eq. kd0 .or.
     *               subcode .eq. kd0b) then                       
                   p.subcode = subcode
                endif
             else
                p.subcode = charge * regptcl
             endif
          elseif(code .ge. kdeut .and. code .le. khvymax) then
             p.subcode = isign(1, charge) *regptcl
          elseif(code .eq. ktriton ) then
             p.subcode = isign(1, charge) *regptcl
          elseif(code .eq. kneumu .or. code .eq. kneue) then
             if(subcode .eq. regptcl .or.
     *            subcode .eq. antip .or.
     *            subcode .eq. 0  ) then
                p.subcode = subcode
             else
                write(msg, *) ' 3 strange subcode=', 
     *               subcode, ' to cssubc. code=', code
                call cerrorMsg(msg,  0)
             endif   
          elseif(code .ge. klambda .and.
     *            code .le. klambdac) then
             p.subcode = subcode
          else      
             p.subcode = 0      ! should be fixed later
          endif     
       elseif(code .eq. krare) then
          p.subcode = 0
       else     
          write(msg, *) ' code=',code,' invalid to cssubc'
          call cerrorMsg(msg, 0)
       endif
      end
c     ****************************************************
c           set heavy neucleus charge
      subroutine cshvc(code, charge, p)
c           code: Integer. Input.  ptcl code
c         charge: Integer. Input.  ptcl charge (1 or -1)
c                                  indicating only positive or
c                                  negative. True charge is
c                                  set here.
c              p: /ptcl/. Output. heavy neucleus charge 
c                           is set in p.charge
c
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
c----         include '../Zcode.h'
#include  "Zcode.h"
         integer code, charge
         record /ptcl/ p
         character*70  msg
c
         integer zhvy(kdeut:khvymax)/1, 2, 4, 7, 12, 17, 26/
c
         if(code .ge. kdeut .and. code .le. khvymax ) then
            p.charge =  zhvy(code) * isign(1, charge)
         elseif(code .eq. ktriton) then
            p.charge = isign(1, charge)
         else
            write(msg, *) 'error input code=',code,' to cshvc'
            call cerrorMsg(msg, 0)
         endif
       end
c     ***************************************************
c         get heavy neucleus mass number
       subroutine cghvm(code, massn)      
c         code: Integer input. ptcl code
c        massn: Integer  output.  mass number
         implicit none
c----         include '../Zcode.h'
#include  "Zcode.h"
#include  "Zheavyp.h"
         integer code, massn
         character*70  msg
c
c
         if(code .ge. kdeut .and. code .le. khvymax) then
            massn = Code2massN(code)
         else
            write(msg, *) 'error input code=',code,' to cghvm'
            call cerrorMsg(msg, 0)
         endif
       end
c     ****************************************************
c           get particle id 
      subroutine cgpid(code, id)
c           get partilce id in character
c        code: Integer. Input.  particle code defined in COSMOS          
c          id: Character*8. Output. partcle id
         implicit none
c----         include '../Zcode.h'
#include  "Zcode.h"
         integer code
         character*8 id
c
         character*70  msg
         character*8 ida(klast)
         data ida(kphoton)/'photon'/, ida(keta)/'Eta'/,
     *        ida(kelec)/'Electron'/, ida(kmuon)/'Muon'/,
     *        ida(kpion)/'Pion'/,     ida(kkaon)/'Kaon'/,
     *        ida(knuc)/'Nucleon'/,   ida(kneue)/'Nue_e'/,
     *        ida(kneumu)/'Nue_mu'/,  ida(knnb)/'NN~'/,
     *        ida(kddb)/'DD~'/,        ida(kdmes)/'D_meson'/,
     *        ida(krho)/'Rho'/,       ida(komega)/'omega'/,
     *        ida(kphi)/'Phi'/,  ida(kdeut)/'deuteron'/
c                heavy neucleus
         data ida(kalfa)/'Helium'/, ida(klibe)/'LiBiB'/,
     *        ida(kcno)/'CNO'/, ida(khvy)/'NaMgSi'/,
     *        ida(kvhvy)/'SClAr'/, ida(kiron)/'Fe'/
         data ida(ksigma)/'sigma'/, ida(klambda)/'lambda'/,
     *   ida(kgzai)/'gzai'/, ida(klambdac)/'lambdac'/
c


         if(code .ge. 1 .and. code .le. klast)then
              id = ida(code)
         else
              write(msg, *) ' code=',code,' invalid to cgpid'
              call  cerrorMsg(msg,  0)
         endif
      end
c        ------------------------------------------
      subroutine cprptc(p, n)
c           print /ptcl/ strucuture; debug purpose
c      
c----      include '../Zptcl.h'
#include  "Zptcl.h"
      record /ptcl/ p(n)
c
      integer i, j, code
      character*8 id
      character*80 msg

c
      do i=1, n
         code = p(i).code
         call cgpid(code, id)
         write(msg, *) ' ---------code=',p(i).code, ' id=', id
         call cerrorMsg(msg, 1)
         write(msg, *) ' 4 momentum=',(p(i).fm.p(j),j=1, 4), ' mass=',
     *               p(i).mass
         call cerrorMsg(msg, 1)
         write(msg, *) ' charge=', p(i).charge, ' subcode=',
     *    p(i).subcode
         call cerrorMsg(msg, 1)
      enddo   
      end
