c     ******************************************************************
c     *                                                                *
c     * csampNEPIntL: samples integraction length for a given
c     *              non e, gamma  particle in a given material air
c     *                                                                *
c     ******************************************************************
c
c
c     *****************************************************************
      subroutine  csampNEPIntL
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zheavyp.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"

c     **************************************************
c
      real*8 mfp, ek,  xs, et, mass, ctau
c            
c        m.f.p (kg/m**2) = abn /xsec(mb)
c        parameter (aira=14.5, abogn=6.02e23, abn=aira*1.e28/abogn)
      real*8 abogn, toabn
      parameter (abogn=6.02d23, toabn=1.d28/abogn)
      real*8 collkgram, u,length
      real*8  eps/1.e-8/, smallxs/1.e-10/, largexs/1.e10/
      integer ica, ka
      logical useInt2
      record /fmom/ gb
      character*70 msg

      et = TrackBefMove.p.fm.p(4)
      mass = TrackBefMove.p.mass
      ek = max(et - mass, eps)    ! avoid 0 energy.
      ka = TrackBefMove.p.code
      ica = TrackBefMove.p.charge
      call cgetctau(TrackBefMove.p, ctau)
      if(ctau .ne. Infty) then
         if(ek .ne. eps) then
c            get gamma x beta in vector
            call cgetlf(TrackBefMove.p, gb)
c             sample decay length
            call rndc(u)
            length =
     *        - ctau * sqrt(gb.p(1)**2 + gb.p(2)**2 + gb.p(3)**2)
     *           * log(u)
         else
            length = 0.
         endif
         call csetIntInf(length, .true., 'decay')
      endif

c          collisions
      useInt2 = IntModel .eq. 'int2' .and. 
     *  TrackBefMove.p.fm.p(4) .lt. Elund
      if(useInt2) then
         if(ka .eq. kneumu .or. ka .eq. kneue) then
            useInt2 = .false.
         elseif(ka .eq. kmuon) then
            useInt2 = .false.    
         elseif(ka .ge.  kalfa .and. ka .le. khvymax) then
            useInt2 = .false.
         elseif(ka .eq. komega .or. 
     *        ka  .eq. krho .or. ka .eq. kphi) then
            useInt2 = .false.
         elseif(ka .eq. kddb .or. ka .eq. knnb) then
            useInt2 = .false.
         endif
      endif
c
      if(useInt2) then
c                Gheisha should be used for collisions
c                it include elastic scattering;
c                so we use different cross-sections
         call cxsecGheisha(TrackBefMove.p, 
     *        TargetMassN, TargetAtomicN, xs)
         mfp = toabn*TargetMassN/xs ! in kg/m2
c               sample interaction length
         call rndc(u)
         collkgram=-mfp*log(u)
      else
c         get mean free path for collision
         if(ka .eq. kpion .or. ka .eq. keta) then
            if(ica .ge. 0) then ! pi+, 0. 
               call cpiPlusAXsec(TargetMassN, ek, xs)
            else
               call cpiMinusAXsec(TargetMassN, ek, xs)
            endif
         elseif (ka .eq. kkaon) then
            if(ica .ge. 0) then
               call ckPlusAXsec(TargetMassN, ek, xs)
            else
               call ckMinusAXsec(TargetMassN, ek, xs)
            endif
         elseif (ka .eq. kmuon) then
c            mu is assumed to have no collision at present
            xs = smallxs
         elseif (ka .eq. knuc) then
            if(TrackBefMove.p.subcode .eq. antip) then
               if(ek .ne. eps) then
                  call cpbarAXsec(TargetMassN, ek, xs)
               else
                  xs = largexs
               endif
            else
               call cprotonAXsec(TargetMassN, ek, xs)
            endif    
         elseif(ka .ge. kalfa .and. ka .le. khvymax) then    
c           heavy xs
            call cAAXsec(Code2massN(ka), TargetMassN, ek, xs)
         elseif(ka .eq. kneumu) then
            xs= smallxs
         elseif(ka .eq. kneue) then
            xs= smallxs
         elseif(ka .eq. kdmes) then
C            d meson; use mean free path for kaon
            call ckPlusAXsec(TargetMassN, ek, xs)
         elseif (ka .eq. knnb) then
c             nn~ instant decay
            xs= smallxs
         elseif (ka .eq. kddb) then
c           dd~ instant decay
            xs= smallxs
         else
            write(msg,*) ' csampNEPIntL:  strange ptcl: ka=',ka
            call cerrorMsg(msg, 0)
         endif
         if(xs .eq. smallxs) then
            collkgram = Infty
         elseif( xs .eq. largexs) then
            collkgram = 0.
         else
            mfp = toabn*TargetMassN/xs ! in kg/m2
c             sample interaction length
            call rndc(u)
            collkgram=-mfp*log(u)
         endif
      endif
      call csetIntInf(collkgram, .false., 'coll')
      end














