c        Initialize simulation.  
c
      subroutine cbeginRun
      implicit none
#include  "Zmanagerp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zincidentp.h" 
#include  "Zprimary.h"
#include  "Zprimaryv.h"


      character*70 msg
      character*16 temp
      integer jold

c        reset parameters.
      if(BorderHeightH .eq. 0.0) then
         BorderHeightH = HeightOfInj
      endif

      if(DestEventNo(2) .le. 0) then
         DestEventNo(2) = DestEventNo(1)
      endif

      if(Cont) then
c           restore status at the end of previous run
         call crestoreStatus
      endif

c         to lower case letters.
      temp = Generate
      call c2lowerCase(temp, Generate)
      temp = Job
      call c2lowerCase(temp, Job)

      call rndsw(jold, 1)    ! specify random number generator 1.

      if(IntModel .eq. 'int1') then
c           for Lund init.  
         call haddenC
         call chanwnC
      elseif(IntModel .eq. 'int2') then
c         Gheisha; init. Gheisha cannot use hadrin/nucrin in Cosmos
         call gpart
         call gheini
      else
         write(msg, *) 'IntModel=', IntModel,' not supported'
         call cerrorMsg(msg, 0)
      endif
c        initialize  observation  
      call cinitObs
c        init for   primary sampling
      call ciniSPrim(PrimaryFile)

      if(CutOffFile .ne. ' ') then
         call crigCut0(CutOffFile) ! read cutoff talbe and init.
      endif

      call ciniSPrimAng    !  this is in csPrimaAgn.f in Tracking dir.
      call ciniTracking0  !  init for  tracking for all events
c        check job
      call cwhatJob
c         user hook
      call chookBgRun
      end
      subroutine ciniTracking0
      implicit none
#include  "Zmanagerp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zheavyv.h"
c
      integer i

      ObserveAS = index(Generate, 'as')  .gt. 0 .or.
     *            index(Generate, 'lat') .gt. 0 
      if(index(Generate, 'qas') .gt. 0) then
         SkipPtclGen = 1  ! quick as generation for heavies.
      else
         SkipPtclGen = 0
      endif

      EventsInTheRun = 0
      if(InitRN(1) .ne. 0) then
         call rnd1r(InitRN)     ! init randeom number generator
      endif
c          compute the offset point in 'xyz' system
c        the deepest detector origin + Offset is the point
c        to which the primary is directed.
c         offset in the detector system.
      Offset.r(1) = 0.
      Offset.r(2) = 0.
      Offset.r(3) = OffsetHeight
c        convert it to xyz system.
      call cdet2xyz(ObsSites(NoOfSites).pos.xyz, Offset, Offset)
c        make it offset 
      do i= 1, 3
         Offset.r(i) = Offset.r(i) -
     *    ObsSites(NoOfSites).pos.xyz.r(i)
      enddo
      end
c     ************
      subroutine  cwhatJob
c     ************
      implicit none
#include  "Zmanagerp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
c   
c
c
      character*90  msg
      integer klena
      character*8  uid 

      if(Job .eq. ' ' .or. Job .eq. 'skeleton') then
c          save present conditions
         KEminObs2 = KEminObs
         Generate2 = Generate
         NoOfSites2 = NoOfSites
         EndLevel2 = EndLevel
         if(Job .eq. ' ') then
            if(SeedFile .ne. ' ') then
c                  open seed file for output
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               open(SeedFileDev, file=SeedFile, form='formatted')
            endif               
         elseif(Job .eq. 'skeleton') then
            call
     *      cerrorMsg('  ********** skeleton making **********', 1)
            write(msg, *)  '      Generate=', Generate
            call cerrorMsg(msg, 1)
c               save skeleton inf. in skelotonFile file.
            open(TempDev, file=SkeletonFile, form='formatted')
            call cwriteParam(TempDev, 1)
            close(TempDev)
c                open SeedFile 
            if(SeedFile .eq. ' ') then
c                error. you need file
               write(msg, *)
     *         ' SeedFile must not be blank for skelton making'
               call cerrorMsg(msg, 0)
            else
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               open(SeedFileDev, file=SeedFile, form='formatted')
            endif
         endif
      elseif(Job   .eq. 'flesh') then
c             don't worry about KEminObs2 etc.  They have been read
c             from &Hparam
          call cerrorMsg('  ********** fleshing job   *********', 1)
          write(msg, *)  '      Old Generate=', Generate2
          call cerrorMsg(msg, 1)
          write(msg, *)  '      New Generate=', Generate
          call cerrorMsg(msg, 1)
          if(EndLevel .gt. EndLevel2) then
c                to deeper detph than skeleton
             write(msg, *)
     *        ' fleshing will be done to deeper depth than'//
     *        ' skeleton making time'
             call cerrorMsg(msg, 1)
             write(msg, *) ' No of old levels=', EndLevel2,
     *       ' No of new levels=', EndLevel
             call cerrorMsg(msg, 1)
          elseif(EndLevel .lt. EndLevel2) then
             call cerrorMsg('EndLevel must be >= skelton time', 0)
          endif
c                open SeedFile
          if(SeedFile .eq. ' ') then
             write(*, *) ' SeedFile must not be blank for flesh job'
             call cerrorMsg(msg, 0)
          else
             write(msg, *) 'opening SeedFFile=', 
     *        SeedFile(1:klena(SeedFile))
             call cerrorMsg(msg, 1)
             open(SeedFileDev, file=SeedFile, form='formatted')
          endif
      else
           write(msg,*) ' Job=',Job, ' undefined'
           call cerrorMsg(msg, 0)
      endif
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. Trace .gt. 100) then
c           defalut trace.  fix the dirctor
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid)
             TraceDir = '/tmp/'//uid(1:klena(uid))
          endif
       endif
      end
c        **************************************** read cont job info
      subroutine crestoreStatus
      implicit none
#include "Zmanagerp.h"
      open(TempDev, file=ContFile, form='formatted')
      call creadParam(TempDev)
      close(TempDev)
      end
