c    ******************************************************************
c    *                                                                *
c    *   cpimu:  pi-->mu decay with polarization
c    *                                                                *
c    ******************************************************************
c
c
c
      subroutine cpiMuDecay(pj,  mupol, a, np, polari)
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
#include  "Zcode.h"
      
      record /ptcl/ pj    !  input. pion
      logical mupol    !  if T, polarization is taken into account
      record /ptcl/ a(*)   ! to store decay product
      integer np     !    no. of ptcls stored in a 
      real*8   polari
      integer subcode, charge
c
c           pi --> mu+neumu (muon should be set last)
      subcode =  -pj.charge
      call cmkptc(kneumu,  subcode, 0,  a(1))
      charge =  pj.charge
      call cmkptc(kmuon,  0,  charge,   a(2))
      call c2bdcy(pj, a(1), a(2))
c               set polarization of muon

      if(mupol) then
         call cpimuPolari(pj, a(2), polari)
      else
         polari=0.
      endif
      np=2
      end
