c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file that exists already
c  *     for formatted i/o mode. If it doen not
c  *     exist or cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenf(io, fn, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fn: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
         character*(*) fn
         logical opn, ex
         integer io, ios, icon
c                  see if already opened.
             inquire(file=fn, opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
                 open(io, file=fn, 
     *           iostat=ios, access='sequential',
     *           form='formatted') 
                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(*, *)' file=',fn,
     *               ' exists but cannot be opened'
                     write(*,*) ' see copnef.f in Manager dir'
                     icon =1
                 endif    
             else
                 write(*, *) ' file=', fn,' not exist'
                 icon = 1
             endif    
         end
