c       *******************************************************
c       *  csampPrimary: samples a primary particle; its type
c       *                 and energy
c       *******************************************************
c   Note:  Here primary spectrum information is contained in common
c       variable Prim (done by init routine). 
c       If we  give it to csampPrimary0 we get
c       one sampled priamary of which energy etc is given in
c       variable in Prim.  Only /ptcl/ information is returned
c       to the caller.
c
        subroutine csampPrimary(p)
c          p: /ptcl/  output.  energy, particle code, subcode,
c                              charge, mass are set.
c  

        implicit none
#include  "Zmanagerp.h"
#include  "Zptcl.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"

        record /ptcl/  p
        call csampPrimary0(Prim)
        call cconv_prim_e(Prim)   ! to total energy
        p = Prim.particle
        Prim.NoOfSamplings =  Prim.NoOfSamplings  + 1  ! update counter.
        end
c       ************************* see if geomagnetic cut or not.
        subroutine cifCutOff(icon)
        implicit none
#include "Ztrack.h"
#include "ZrigCut.h"

         integer icon   !   output. 0 ==> not cut. 1 ==> cut.

         record /coord/ angleatOb
         record /track/ inc

         real*8 p, rig, zen, azm, theta, rigcut

         call cqIncident(inc, angleatOb)

         if(inc.p.charge .eq. 0) then
            icon = 0
         else
c            angleatOb is down going ptcl's one, change sign
            angleatOb.r(1) = - angleatOb.r(1)
            angleatOb.r(2) = - angleatOb.r(2)
            angleatOb.r(3) = - angleatOb.r(3)
c             convert to theta fai in deg
            call kdir2deg(angleatOb.r(1), angleatOb.r(2),
     *      angleatOb.r(3), theta, azm)
            if(ZenValue .eq. 'cos') then
c                table zenith is in cos
               zen = angleatOb.r(3)
            else
               zen = theta
            endif
            call crigCut(azm, zen, rigcut)
            p = sqrt(inc.p.fm.p(4)**2 - inc.p.mass**2)
            rig = p/abs(inc.p.charge)
            if(rig .lt. rigcut) then
               icon = 1
            else
               icon = 0
            endif
         endif
         end

c       ************************************
        subroutine csampPrimary0(prm)
        implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
        record /primaries/ prm

        real*8 p_or_e
c
        integer i
        real*8 u
c
c          select one component
        call rndc(u)
        i = 1
        do while (u .gt. prm.cummInteFlux(i) )
           i = i + 1
        enddo
        prm.label = prm.each(i).label
c
        call csampPrimary1(prm.each(prm.label), p_or_e)
        prm.sampled_e = p_or_e
        end
        subroutine csampPrimary1(each, p_or_e)
        implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
        record /component/ each
        real*8 p_or_e
c
        real*8 e1temp, ombeta, u
        integer i
c
        if( each.no_of_seg .eq. 0) then
           p_or_e = each.emin       ! = emax
        else
c              discard E> Emax
           do while(.true.)
              call rndc(u)
              if(u .ge. each.norm_inte(each.no_of_seg +1)) goto 10
           enddo
 10        continue
c
           i = each.no_of_seg 
           do while (u .gt. each.norm_inte(i))
               i = i - 1
           enddo
c             use i-th segment
           if(each.diff_or_inte .eq. 'd') then    
               ombeta = (1.d0 - each.beta(i))           
               if(abs(ombeta) .gt. 1.d-6) then
                  e1temp = each.energy(i)**ombeta
                  call rndc(u)
                  p_or_e =( u* (each.energy(i+1)**ombeta - e1temp) +
     *             e1temp )** (1.d0/ombeta)
               else    
                  p_or_e = each.energy(i+1)**u
               endif
           elseif(each.diff_or_inte .eq. 'i') then
               call rndc(u)
               p_or_e = each.energy(i)* (1.d0 - 
     *          u*(1.d0 - each.norm_inte(i+1)/each.norm_inte(i)))
     *          **(-1.D0/each.beta(i))
           else
               write(*, *) ' invlid diff_or_inte=',each.diff_or_inte,
     *         ' for primary=',each.symb
               stop 9999
           endif     
         endif  
         end
         subroutine cconv_prim_e(prm)
         implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zprimary.h"
         record /primaries/ prm
         integer label, code, massn
c       
         real*8 seinGeV  ! sampled primary in GeV

         label = prm.label
c
         seinGeV= prm.sampled_e *   prm.each(label).togev
         call cmkptc(prm.each(label).code,
     *               prm.each(label).subcode,
     *               prm.each(label).charge,
     *               prm.particle)        
         if(prm.each(label).etype .eq. 'e/p' .or.
     *      prm.each(label).etype .eq. 'e') then
            prm.particle.fm.p(4) = seinGeV
     *                  
         elseif(prm.each(label).etype .eq.'p/p' .or.
     *      prm.each(label).etype .eq. 'p')then
            prm.particle.fm.p(4) = sqrt(prm.particle.mass**2 +
     *             seinGeV**2)
         elseif(prm.each(label).etype .eq. 'ke/p' .or.
     *      prm.each(label).etype .eq. 'ke') then
            prm.particle.fm.p(4) = seinGeV + prm.particle.mass
         elseif(prm.each(label).etype .eq. 'e/n') then
            code = prm.each(label).code
            if(code .ge. kdeut .and. 
     *         code .le. khvymax) then
               call cghvm(code, massn)
               prm.particle.fm.p(4) = massn * seinGeV
            else
               prm.particle.fm.p(4) =  seinGeV
            endif
         elseif(prm.each(label).etype .eq. 'ke/n') then
            code = prm.each(label).code
            if(code .ge. kdeut .and. 
     *         code .le. khvymax) then
               call cghvm(code, massn)
               prm.particle.fm.p(4) = massn * seinGeV +
     *            prm.particle.mass
            else
               prm.particle.fm.p(4) = seinGeV +
     *            prm.particle.mass
            endif
	 elseif(prm.each(label).etype .eq. 'p/n') then
            code = prm.each(label).code
            if(code .ge. kdeut .and. 
     *         code .le. khvymax) then
               call cghvm(code, massn)
               prm.particle.fm.p(4) =
     *      	  sqrt( (massn * seinGeV) **2 + 
     *            prm.particle.mass **2)
            else
               prm.particle.fm.p(4) = sqrt(seinGeV**2 +
     *            prm.particle.mass**2)
            endif
         else
            write(*, *) ' energy type=',prm.each(label).etype,
     *                  ' invalid. label=', label, ' symb =',
     *                  prm.each(label).symb
            stop 9999
         endif
        end
c       *******************************************************
c       *  cqPrimE: inquire sampled primary energy or p
c       *                    as it is
c       *******************************************************
c
        subroutine cqPrimE(p_or_e)
c  
        implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
        real*8 p_or_e
        call cqPrimE0(Prim, p_or_e)
        end
c       *******************************************************
c       *  cqPrimE0: inquire sampled primary energy or p
c       *                     as it is
c       *******************************************************
c
        subroutine cqPrimE0(prm, p_or_e)
c  
        implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
        real*8 p_or_e
        record /primaries/ prm
c
        p_or_e = prm.sampled_e
c
        end
c       *******************************************************
c       *  cqPrimLabel: inquire sampled primary label

c       *******************************************************
c
        subroutine cqPrimLabel(label)
c  
        implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
        integer label
        call cqPrimLabel0(Prim, label)
        end
c       ************************  inquire the number of primaries sampled
        subroutine cqNoOfPrim(no)
c       ************************
        implicit none
#include  "Zmanagerp.h"
        integer no   ! output.  no. of sampled primaries so far.
        no = EventNo
        end

c       *******************************************************
c
        subroutine cqPrimLabel0(prm,label)
c  
        implicit none
#include  "Zptcl.h"
#include  "Zprimary.h"
        integer label
        record /primaries/ prm

        label = prm.label
        end
c       *******************************************************
c           inquire all about current primaries
        subroutine cqPrimary(prm)
c         prm /primaires/ output.
c  
        implicit none
#include  "Zptcl.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"

        record /primaries/ prm
        prm = Prim
        end

