      subroutine ckf2cos(kf, code, subcode, chg)
c        kf code to cosmos code.
      implicit none
#include "Zcode.h"
#include "Zkfcode.h"

      integer kf   ! input
      integer code, subcode, chg  ! output. For spectator kf, code=0
c                                           for tau neutrio,  code = 0

      integer kfabs
      kfabs = abs(kf)

      if(kfabs .eq. kfpip) then
         code = kpion
         subcode = sign(regptcl, kf)
         chg = sign(1, kf)
      elseif(kf .eq. kfpi0) then
         code = kpion
         subcode =regptcl
         chg = 0
      elseif(kfabs .eq. kfkp) then
         code = kkaon
         subcode =sign( regptcl, kf)
         chg = sign(1, kf)
      elseif(kf .eq.  kfk0l) then
         code =kkaon
         subcode = k0l
         chg = 0
      elseif(kf .eq.  kfk0s) then
         code = kkaon
         subcode = k0s
         chg = 0
      elseif(kfabs .eq. kfneutron) then
         code =knuc
         if(kf .gt. 0) then
            subcode = kneutron
         else
            subcode = kneutronb
         endif
         chg = 0
      elseif(kfabs .eq. kfproton) then
         code = knuc
         if(kf .gt. 0) then
            subcode = regptcl
         else
            subcode = antip
         endif
         chg =sign(1, kf)
      elseif(kfabs .ge. 10000) then
         code = 0   ! target spectator. neglect
      elseif(kf .eq. kfeta) then
         code= keta
         subcode = regptcl
         chg = 0
      elseif(kfabs .eq. kfem) then
         code = kelec
         subcode = sign(regptcl, kf)
         chg = sign(-1, kf)
      elseif(kfabs .eq. kfmum) then
         code = kmuon
         subcode =sign( regptcl, kf)
         chg = sign(-1, kf)
      elseif(kfabs .eq. kfneue) then
         code = kneue
         subcode =sign( regptcl, kf)
         chg = 0
      elseif(kfabs .eq. kfneumu) then
        code = kneumu
        subcode =sign( regptcl, kf)
        chg = 0
      elseif( kf .eq.  kfgamma) then
         code = kphoton
         subcode = 0
         chg = 0
      elseif(kfabs .eq. kfdmesp) then
         code = kdmes
         subcode = sign( regptcl, kf)
         chg = sign(1, kf)
      elseif(kfabs .eq. kfd0) then
         code =kdmes
         subcode = sign(regptcl, kf)
         chg = 0
      elseif(kfabs .eq. 16) then
         code = 0    !  tau neutrion. neglect 
      else
         write(*, *) 'strange kf code=', kf
         stop
      endif
      end
      subroutine ccos2kf(code, subcode, chg, kf)
c         cosmos code to kf code
c         only hadronic interacting particles are treaed.
      implicit none
#include "Zcode.h"
#include "Zkfcode.h"
      integer code, subcode, chg  ! input
      integer kf   ! output

      if(code .eq. kpion) then
         if(chg .eq. 0) then
            kf = kfpi0
         else
            kf = sign(kfpip, chg)
         endif
      elseif(code .eq. kkaon) then
         if(chg .eq. 0) then
            if(subcode .eq. k0l) then
               kf = kfk0l
            else
               kf = kfk0s
            endif
         else
            kf = sign(kfkp, chg)
         endif
      elseif(code .eq. knuc) then
         if(chg .eq. 0) then
            if(subcode .eq. regptcl) then
               kf = kfneutron
            else
               kf = -kfnbar
            endif
         else
            kf = sign(kfproton, chg)
         endif
      else
         write(*, *) 'strange code, subcode, chg to  ccostokf=', 
     &      code, subcode, chg         
         stop
      endif
      end
