cc       to test cgetRotMat4, cinvRotMat4, cmultRotMat4, capplyRot4
cc           cgetRotMat4: get rotation matrix of x/y/z axis
cc           cinvRotMat4: invert a rotation matrix
cc           cmultRotMat4:  multiply two rotation matrix
cc           capplyRot4: applay a rotation on a 3d vector.
cc
c         implicit none
c         include '../Zptcl.h'
c         record /fmom/ vn, v
c         real*8 rm(4, 4),  rmn(4,4), rmm(4,4)
c         real*8  Torad
c         integer i, j, m
c         v.x =1.
c         v.y =0.
c         v.z =1.
cc
c         do i=1, 4
c            do j=1, 4
c                rm(i, j)=1.d30
c                rmn(i, j)=-1.d30
c                rmm(i, j)=1.d15
c            enddo
c         enddo
c         do i=1, 3
c            vn.p(i)= 1.e50
c         enddo
c         Torad=asin(1.d0)/90.d0
c         m=3
c         call cgetRotMat4(m, 45.*Torad, rm)
c         call cinvRotMat4(rm, rmn)
c         call cgetRotMat4(m, -45.*Torad, rmm)
c         write(*, *) ' rotation matrix around m=', m
c         do 10 i=1, 4
c             write(*,*) (rm(i,j),j=1, 4)
c  10     continue
c         write(*,*) "-----inverse of the above--"
c         do 20 i=1, 4
c             write(*,*) (rmn(i,j),j=1, 4)
c  20     continue
c         write(*,*) "-----should be the same as above--"
c         do 30 i=1, 4
c             write(*,*) (rmm(i,j),j=1, 4)
c  30     continue
c         write(*,*) "-------"
c         call capplyRot4(rm, v, vn)
c         write(*, *) ' v is rotated by rm'
c         write(*,*) vn.p
c         call cmultRotMat4(rm, rmn, rmm)
c         write(*, *)' unit matrix should be seen'
c         write(*, *) rmm
c         call capplyRot4(rmm, v, vn)
c         write(*, *) " no change from v"
c         write(*,*) vn.p
c        end
c        **************************************************************
c        *
c        *  cgetRotMat4: make rotation matrix of 3-d coordinate axes.
c        *
c        **************************************************************
c  /usage/  call cgetRotMat4(m, ang, rm)
c
c    m: input. integer  1--> rotaion of coordinate around x axis
c                       2-->   //                         y
c                       3-->   //                         z
c                     rotation is made anticlock wise (e.g,
c                     if m=3,
c                                  !y    / new x
c                    $  new y      !    /
c                        $         !   / *
c                            $     !  /   * ang ( if > 0)
c                                $ ! /     *
c                                   ~~~~~~~~~~~~~~~~~ x
c                         z is directed to the eyes.
c       ang: input. real*8.  rotation angle in radian.
c   rm(4,4): output. real*8  rotation matrix.  v'=rm*v is the new coordinate
c                   of a vector v(see capplyRot4)
c
      subroutine cgetRotMat4(m, ang, rm)
          implicit none
c
          integer m
          real*8 ang
          real*8 rm(4, 4)
c
          integer i, j, m1, m2
          real*8 c, s
c
          if(m .ge. 1 .and. m .le. 3) then
             do i=1, 4
                do j=1, 4
                   rm(i, j)= 0.d0
                enddo
             enddo   
             rm(4,4)=1.d0
             rm(m, m)=1.d0
             m1=mod(m,3)+1
             m2=mod(m1,3)+1
             c=cos(ang)
             s=sin(ang)
             rm(m1,m1)=c
             rm(m2,m2)=c
             rm(m1,m2)=s
             rm(m2,m1)=-s
          else
             write(*,*) ' invalid m=',m,' to cgetRotMat4 '
             stop  9999
          endif
      end
      subroutine cinvRotMat4(rm, rmn)
c             Invert rotation matrix rm and put into rmn.
c             rm should be a roation matrix made by calling
c             cgetRotMat4 (with ang).  rmn can be made by calling
c             cgetRotMat4 with -ang, too.  this one is to avoid
c             computing the cos and sin for reducing time.
c             rmn cannot be the same arrays as rm.
c             rmn is nothing but the transposed matrix of rm.
          implicit none
          real*8 rm(4,4), rmn(4,4)
          integer i, j
          do  i=1,4
             do  j=i+1, 4
                rmn(i,j)=rm(j, i)
                rmn(j,i)=rm(i, j)
             enddo
          enddo
          do  i=1, 4
             rmn(i,i)=rm(i, i)
          enddo
       end
       subroutine cmultRotMat4(a, b, c)
c            3-d matrix product c=a*b
c            c cannot be either of a or b.
          implicit none
          real*8 a(4,4), b(4,4), c(4,4)
          integer i, j, k
          real*8 ab
          do  i=1, 4
             do j=1, 4
                ab=0.
                do k=1, 4
                   ab=ab+ a(i,k)*b(k,j)
                enddo
                c(i,j)=ab
             enddo   
          enddo
       end
       subroutine capplyRot4(a, v, vn)
c          3-d transformation matrix a is multiplied by
c          a vector v to obtain a new vector vn.
c          vn can  be v.
c
           implicit none
c----           include '../Zptcl.h'
#include  "Zptcl.h"
           record /fmom/ v, vn
           real*8 a(4,4)
           record /fmom/ tmp
c
           real*8 sum
           integer i, j
c
          do  i=1, 3
             sum=0.
             do  j=1, 4
                 sum=sum + a(i, j)*v.p(j)
             enddo    
             tmp.p(i)=sum
          enddo
          vn = tmp
       end

