#include "chookHybAS.f"
#include "ctemplCeren.f"
#include "ZcosmosBD.h"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"

 
c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.

c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)
      end


c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none

      end
  

c     ************************************ hook for observation
c     *  One particle information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Ztrack.h"
      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
      if(id .eq. 2) then
c            output typical quantities.
        write(*, *) 
     *  aTrack.where,   !  observation level. integer*2.  1 is highest.
     *  aTrack.p.code,    !  ptcl code.  integer*2.
     *  aTrack.p.charge,  !  charge,  integer*2 
     *  sngl(aTrack.t), !  relateive arrival time in nsec (NOT sec).
                        !  if TimeStructure is F, nonsense.
     *  sngl(aTrack.p.fm.e),  ! total energy in GeV.
     *  sngl(aTrack.pos.xyz.x), sngl(aTrack.pos.xyz.y), !  x, y in m
     *  sngl(aTrack.vec.w.x),  ! direc. cos.x in the current detector system.
     *  sngl(aTrack.vec.w.y),  ! direc. cos.y
     *  sngl(aTrack.vec.w.z),  ! direc. cos.z
     *  sngl(aTrack.vec.coszenith) ! cos of zenith angle
      endif
c         you may need in some case other information such as
c       aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
                           ! ThinSampling =T)
c       aTrack.p.fm.x      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.y      !          y
c       aTrack.p.fm.z      !          z
c       aTrack.pos.colheight  ! the lastest nuclear collision vertical height
      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      integer i
      if(ObserveAS) then
c                   electron size in B approx.
         write(*, *) (ASObsSites(i).esize, i=1, NoOfASSites)
c                   size weighted age
         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites) 
      endif
      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
#include "Ztrack.h"
#include "Ztrackp.h"
      integer klena
      character*100  tracefile
      character*1  qm/"'"/

      tracefile = TraceDir(1:klena(TraceDir))//'/trace1'
        write(*, *)
     * '****** Congratulations: Cosmos is now your friend *******'
        write(*, *)
     * '       particle trace data has been created'//
     *     ' in '//tracefile
        write(*, *)
     * '       you can see it by gnuplot: For that, in gnuplot do'
        write(*, *)
     * '       set para'
        write(*, *)
     * '       splot "',tracefile(1:klena(tracefile)),'" w  l'
        write(*, *)
     * '   To see charged particles only, use following '
        write(*, *)  '      splot  "< awk ',qm,' $6 != 0 {print} \ '
        write(*, *)  '           NF == 0 {print}',qm, ' \ '
        write(*, *)  '         ',tracefile(1:klena(tracefile)),
     *       ' " w l '
#ifdef sun4
        write(*, *) ' The last 3 lines should be on 1 line or',
     *  ' you need contination backslash'
#endif
       
        write(*, *)
     * '************      Have a nice day !!      **************'
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 60
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

      real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 60. 
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat',or  'anihi'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' or 'photop'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process  will have
c             'coll' or 'decay'
      end

      
