c            test ctransVectZ
c      implicit none
c      include 'Zcoord.h'
c      record /coord/ wa, dc, ans
c      real*8 cst, snt, fai
c     wa.r(1)=.50
c      wa.r(2)=0.5
c      wa.r(3)=sqrt(1. - (wa.r(1)**2+wa.r(2)**2))
c      cst=0.8
c      snt=sqrt(1.-cst**2)
c      do fai=0., 2*3.1415, .1
c         dc.r(1)=snt*cos(fai)
c         dc.r(2)=snt*sin(fai)
c         dc.r(3)=cst
c         call ctransVextZ(wa, dc, ans)
c         write(*,*) sngl(ans.r(1)), sngl(ans.r(2)),
c    *    sngl(ans.r(3))
c      enddo
c      end
       subroutine ctransVectZ(zax, dir1, dir2)
       implicit none

#include  "Zcoord.h"
       record /coord/ zax, dir1, dir2
       real*8  sml, epsx, av

       parameter (sml=0.001,  epsx=1.e-4, av=.985)

c
c   /usage/ call ctransVectZ(zax, dir1, dir2)
c         Directions cosines(dir1) are given in a system
c         (=R) whose z-axis has direction cosines (zax) in
c         a certain system(=B).
c         This subroutine transform the angles so that (dir1)
c         be the direction cosines in the B-system,
c         and put the result into dir2.
c         The x and y
c         axes of the R-system are chosen so that the transformation
c         becomes simplest. This does not guarantee that the dir2
c         have the same sing as the original one when xax(1) is
c         1.0 or close to 1.0.   If you have to avoid such, 
c         use, ctransVectZ2. (For magnetic deflection, you need this).
c      dir2 can be the same one as dir1, or zax.
c      dir1 need not be  the direction cosine, but can be momentum 
c          or arbitrary  vector.  zax must be direction cos.
c
       real*8 w1a, w2a, w3a, dc1, dc2, dc3, el2, em2, d, a, b, c
       real*8 tmpa, tmpb, tmpc
          w1a=zax.r(1)
          w2a=zax.r(2)
          w3a=zax.r(3)
          dc1=dir1.r(1)
          dc2=dir1.r(2)
          dc3=dir1.r(3)
c
              el2=w1a**2
              em2=w2a**2
              d=1.+w3a
              if(abs(d) .gt. epsx) then
                  a=el2/d - 1.
                  b=w1a*w2a/d
                  c=em2/d - 1.
                  tmpa=a*dc1 + b*dc2 + w1a*dc3
                  tmpb=b*dc1 + c*dc2 + w2a*dc3
              else
                  tmpa= dc2
                  tmpb= dc1
              endif
              tmpc=w1a*dc1 + w2a*dc2 + w3a*dc3
c                  check result
c              eps=tmpa**2 + tmpb**2 + tmpc**2 - 1.
c              if(abs(eps) .gt. 1.e-3) then
c                     renormalize
c                   anrm=sqrt(1.+eps)
c                   tmpa=tmpa/anrm
c                   tmpb=tmpb/anrm
c                   tmpc=tmpc/anrm
c              endif
          dir2.r(1)=tmpa
          dir2.r(2)=tmpb
          dir2.r(3)=tmpc
        end
