#include "ZsubstRec.h"
c            treat interaction of MovedTrack
c
      subroutine cinteraction
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
c

c
c          used to judge if user hook should be called 
c          after MovedTrack interacted.
c
      integer neverNEP/0/,  neverE/0/,  neverG/0/
      save  neverNEP, neverE, neverG
      integer never

      record /ptcl/ fragA(maxHeavyMassN),  nonIntNucA(maxHeavyMassN)
      integer noOfFrag, noOfNonIntN
c
      record /track/aTrack
c
c   **  ptcl stacking is done in each subroutine; should be changed
c           (except for hadronic interactions)

      Nproduced = 0

      if(MovedTrack.p.code .eq. kelec) then
         call cinteElec
         if(neverE .ne. 1) then
            call chookEInt(neverE)
            never = neverE
         endif

      elseif(MovedTrack.p.code .eq. kphoton) then

          call cintePhoton
          if(neverG  .ne. 1)  then
             call chookGInt(neverG)
             never = neverG
          endif

      else
          call cinteNEP
          if(IntInfArray(ProcessNo).process .eq. 'coll') then
             MovedTrack.pos.colheight = MovedTrack.pos.height
          endif
c             interface with user hook  ***********************
          if(neverNEP .ne. 1) then
             call chookNEPInt(neverNEP)
             never = neverNEP
          endif
c             *******************************
      endif


      if( never .eq. 1 .or. never .eq. 0) then
         if(OneDim .eq. 0) then
c            3 dimensional
            aTrack = MovedTrack ! copy inf. other than /ptcl/
c                 stack the leading ptcl  first (to save stack area)
            call cmovePtcl3(aTrack, Pwork, Nproduced)
         else
            aTrack = MovedTrack
            aTrack.vec = IncidentCopy.vec
            call cmovePtcl1(aTrack, Pwork, Nproduced)
         endif
      elseif(never .eq. 2) then
c              save only fragments and non interacting nucleons
         if(MovedTrack.p.code .ge. kdeut .and. 
     *      MovedTrack.p.code .le. khvymax ) then
c               get fragment and non interacting nuc.

            call cqHvyIntF(fragA, noOfFrag)
            call cqHvyIntNIN(nonIntNucA, noOfNonIntN)

            if(OneDim .eq. 0) then
                aTrack = MovedTrack ! copy inf. other than /ptcl/
                call cmovePtcl3(aTrack, fragA, noOfFrag)
                call cmovePtcl3(aTrack, nonIntNucA, noOfNonIntN)
             else
                aTrack = MovedTrack
                aTrack.vec = IncidentCopy.vec
                call cmovePtcl1(aTrack, fragA, noOfFrag)
                call cmovePtcl1(aTrack, nonIntNucA, noOfNonIntN)
             endif
          endif
      elseif(never .eq. 3) then
c              don't follow all this child
      elseif(never .eq. 4) then
c             discard this event
c             clear stack
         call cinitStack
      else
         call cerrorMsg('return value from chookE,G,NEPInt wrong', 0)
      endif
      end
c     ************************************
c          move partcles in a given array to stack
c          3 dimensional case.

      subroutine  cmovePtcl3(aTrack, pw, n)
      implicit none

#include  "Ztrack.h"
c
      integer n
      record /track/ aTrack
      record /ptcl/ pw(n)

      integer i

      do i =  n, 1, -1          ! move leading ptcl first
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif
c               reset direction cos and related stuffs
         call cresetDirec(aTrack)
         call cpush(aTrack)
      enddo
      end
c     ************************************
c          move partcles in a given array to stack
c          1 dimensional case.

      subroutine  cmovePtcl1(aTrack, pw, n)
      implicit none


#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Zincidentv.h"


      integer n
      record /track/ aTrack
      record /ptcl/ pw(n)
      real*8 temp, p
  
      integer i
      do i =  n, 1, -1          ! move leading ptcl last
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif
c            see if angle of particle is larger than a lmit
         call cscalerProd(aTrack.p.fm.p, DcAtObsXyz, temp)
         call cpxyzp(aTrack.p.fm, p)
         if(p .gt. 0.) then
            temp = temp/p
         else
            temp = 1.
         endif
         if(temp .gt. BackAngLimit)  then
c              only take some limitted angle particles
c            call cresetMom(aTrack)  which is
            aTrack.p.fm.p(1) = p * aTrack.vec.w.r(1)
            aTrack.p.fm.p(2) = p * aTrack.vec.w.r(2)
            aTrack.p.fm.p(3) = p * aTrack.vec.w.r(3)

            call cgetZenith(aTrack, aTrack.vec.coszenith)
            call cpush(aTrack)
         endif
      enddo
      end

c     ****************************************************************
      subroutine cqIntePtcl(ptclA, num)
      implicit none
c          inquire the particle information that made interactions
c        to produce secondary particles.
c        If "MovedTrack" is a heavy,  ptclA will get interacting nucleons
c        otherwise, ptclA will have MovedTrack.p itself.
c
c           
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"

      record /ptcl/ ptclA(*)   ! output. interacted particles. max size
                               ! should be maxHeavyMassN (= 56 =Fe)
      integer num              ! output. number of ptcls in ptclA
c
c
      if(MovedTrack.p.code .ge. kdeut .and. 
     *    MovedTrack.p.code .le. khvymax ) then
         call cqHvyIntIN(ptclA, num)
      else
#ifdef SUBSTREC
         ptclA(1) = MovedTrack.p
#else
         ptclA(1).fm.p = MovedTrack.p.fm.p
         ptclA(1).mass = MovedTrack.p.mass
         ptclA(1).code = MovedTrack.p.code
         ptclA(1).subcode = MovedTrack.p.subcode
         ptclA(1).charge = MovedTrack.p.charge
#endif
      endif
      end

      
