c       **************************************************************
c       *
c       *  cgeomag: geomagnetic filed strength is obtained
c       *
c       **************************************************************
c  /usage/ call cgeomag(year, llh,  h, icon)
c   year: real*8. input.  such as 1990.5
c   llh:  /coord/ input.  position around the earth. 
c                         in 'llh' form is better. if not 'llh'
c                         conversion is done here.
c     h:  /magfield/. output.  magnetic field is set in
c                         the form of 'ned' (north, 
c                         east-down). The unit is T.
c  icon:  output. integer*4  0---> o.k
c                            1---> input parameter wrong.
c
c  according to rikanenpyou 1990. ed.
c          accuracy depends on the place.  at good place, 2 digit
c       can be obtained accurately.
c
       subroutine cgeomag(year, llh, h,  icon)
       implicit none
#include  "Zglobalc.h"
#include  "Zcoord.h"
#include  "Zmagfield.h"
#include  "Zearth.h"
       real*8 year
       record /coord/ llh
       record /magfield/ h
       integer icon
c
       integer nmx, nd
       parameter (nmx=8, nd=(nmx-1)+nmx*(nmx-1)/2 + nmx+ 1)
       real*8 gmn(nd), hmn(nd), gmnd(nd), hmnd(nd)
c
       real*8 r, sumn, sume, sumd, t, cost, sint, x, tlonr, gmnc, 
     *       cosml, sinml, hmnc, tmp, gn, ge, gd
       integer m, l, n
       record /coord/ cdata
       real*8 kdpmnxn, kpmnxn, kdpnxn       ! Legendre functions

       data gmn/
     * -29988., -1957., -1997., 3028., 1662., 1279.,
     * -2181., 1251., 833., 938., 783., 398., -419.,
     *   199., -219., 357., 261., -74., -162., -48.0,
     *   49., 65., 42., -192., 4., 14., -108., 70.,
     *   -59., 2., 20., -13., 1., 11., -2., 20.,
     *  7., 1., -11., -7., 4., 3., 7., -1./
c
       data hmn/
     * 0.,  5606., 0., -2129., -199.,  0., -355., 271.,
     * -252., 0., 212., -257., 53., -298., 0., 46.,
     * 149., -150., -78., 92., 0., -15., 93., 71., -43.,
     * -2., 17., 0., -83., -28., -5., 16., 18., -23.,
     * -10., 0., 7., -18., 4., -22., 9., 16., -13., -15./
c
       data gmnd/
     * 22.4, 11.3,-18.3, 3.2, 7.0, 0., -6.5, -0.7, 1.,
     * -1.4, -1.4, -8.2, -1.8, -5.0, 1.5, 0.4, -0.8,
     * -3.3, 0.2, 1.4, 0.4, 0., 3.4, 0.8, .8, .3,
     * -0.1, -1., -0.8, 0.4, 0.5, 1.6, 0.1, 0.1, 0.,
     *  0.8, -0.2, -0.3, 0.3, -0.8, -0.2, 0.7, -0.3, 1.2/
c
       data hmnd/
     * 0., -15.9, 0., -12.7, -25.2, 0., 0.2, 2.7, -7.9,
     * 0., 4.6, 1.6, 2.9, 0.4, 0., 1.8, -0.4, 0., 1.3,
     * 2.1, 0., -0.5,-1.4, 0., -1.6, 0.5, 0., 0.,  -0.4,
     * 0.4, 0.2, 1.4, -0.5, -0.1, 1.1,0., -0.1, -0.7, 0.,
     * -0.8, 0.2, 0.2, -1.1, 0.8/
c
c
c         check data type
       if(llh.sys .eq. 'llh') then
          cdata = llh
       else     ! convet to llh
          call ctransCoord2('llh', llh, cdata)
       endif   
c
       if(year .lt. 1970.  .or. year .gt. 2010.)then
           icon=1
c       elseif(abs(cdata.lat) .gt. 90.) then
       elseif(abs(cdata.r(1)) .gt. 90.) then
           icon=2
c       elseif(abs(cdata.long) .gt. 360.) then
       elseif(abs(cdata.r(2)) .gt. 360.) then
           icon=2
c       elseif(cdata.h .gt. 5000.d3) then
       elseif(cdata.r(3) .gt. 10000.d4) then
           icon=1
c       elseif(cdata.h .lt. -3000.d3) then
       elseif(cdata.r(3) .lt. -3000.d3) then
           icon=1
       else
c           r=1./( 1.+cdata.h/Eradius )
           r=1./( 1.+cdata.r(3)/Eradius )
           sumn=0.
           sume=0.
           sumd=0.
c           t=(90.-cdata.lat)*Torad
           t=(90.-cdata.r(1))*Torad
           cost=cos(t)
           sint=sin(t)
           x=cost
c           tlonr=cdata.long*Torad
           tlonr=cdata.r(2)*Torad
           do   n=1, nmx
               do   m=0, n
                  l=n-1 + n*(n-1)/2 + m+1
                  gmnc=gmn(l) + gmnd(l)*(year-1980.)
                  cosml=cos(m*tlonr)
                  sinml=sin(m*tlonr)
                  if(m .gt. 0) then
                      hmnc=hmn(l)  + hmnd(l)*(year-1980.)
                      sumn=sumn+ r**n * (gmnc*cosml+hmnc*sinml)*
     *                kdpmnxn(m, n, x)
c
                      if(sint .eq. 0. and. m .eq. 1)then
                          tmp=1.
                      else
                          tmp=sint**( (m-1)/2.)
                      endif
                      sume=sume+ r**n * m *(-gmnc*sinml + hmnc*cosml)
     *                  *  kdpnxn(m, n, x)* tmp
c
                      sumd=sumd - r**n * (gmnc*cosml+ hmnc*sinml)
     *                 * kpmnxn(m, n, x) *(n+1)
                  else
                      sumn=sumn+ r**n * gmnc*cosml*
     *                kdpmnxn(m, n, x)
c
                      sumd=sumd - r**n * gmnc*cosml
     *                 * kpmnxn(m, n, x) *(n+1)
                  endif
              enddo
          enddo
c              original formula gives  data in nT.
c              north component
          gn=-sint*r**2 *sumn /1.d9  ! to T.
c              east  component
          ge=-r**2*sume /1.d9
c              down
          gd= r**2 *sumd /1.d9
          call csetMagField('ned', gn, ge, gd, h)
          icon=0
       endif
       if(icon .eq. 2) then
          call cerrorMsg('Geometrical input data wrong', 0)
       endif
       end
