      subroutine cifXObsSite
c         see if MovedTrack crosses an observation depth.
c         or go out of boundry.
c        if to be observed, reset MovedTrack information
      implicit none
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zearth.h"
c     
      integer loc
      real*8  leng, dedt, cosfromaxis
      real*8  clen2thick
c               , clenbetween2h
      logical cross
      record /coord/ xyz1, xyz2, dircos, diffvec
      real*8 dummylen

c
c            see if go out of outer boundery.
      call cscalerProd(MovedTrack.vec.w, DcAtObsXyz, cosfromaxis)
      if(cosfromaxis .lt. BackAngLimit .or.
     *   MovedTrack.pos.height .ge. BorderHeightH) then
c             discard it
         MoveStat = BorderH
         return  !  ***************
      endif
c  -------------------------------------------------------------

      loc = MovedTrack.where 
      if(MovedTrack.pos.height .le. BorderHeightL) then
         MoveStat = BorderL
c         leng = clenbetween2h(TrackBefMove.pos.height+Eradius,
c     *         BorderL+Eradius, TrackBefMove.vec.coszenith)
      endif
      if(ObsPlane .ne. notUsed ) then
         cross = .false.
         if(ObsPlane .eq. horizontal) then
c                  horizontal
            call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
            call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
     *                  TrackBefMove.pos.xyz, xyz1)
            if(TrackBefMove.vec.coszenith .gt. 0.) then
               if( xyz2.r(3) .le. ObsSites(loc).zpl .and.
     *             xyz1.r(3) .gt. ObsSites(loc).zpl ) then
                  cross = .true.
               elseif(loc .lt. NoOfSites) then 
                  if( xyz1.r(3) .gt. ObsSites(loc+1).zpl  .and. 
     *                xyz2.r(3) .le. ObsSites(loc+1).zpl) then
                     cross =.true.
                     loc = loc + 1
                     MovedTrack.where = loc 
                  endif
               endif
            else
               if(xyz1.r(3) .lt.  ObsSites(loc).zpl .and.
     *              xyz2.r(3) .ge.  ObsSites(loc).zpl) then
                  cross = .true.
               elseif(loc .gt. 1) then
                  if(xyz1.r(3) .lt.  ObsSites(loc-1).zpl .and.
     *               xyz2.r(3) .ge.  ObsSites(loc-1).zpl) then
                     cross = .true.
                     loc = loc -1
                     MovedTrack.where = loc
                  endif
               endif
            endif
         elseif(ObsPlane .eq. perpendicular) then
c           observation plane is perpendicular to primary
c           convert coord into 1ry system
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  TrackBefMove.pos.xyz, xyz1)
            call cscalerProd(TrackBefMove.vec.w, DcAtObsXyz, 
     *       cosfromaxis)
            if(cosfromaxis .gt. 0.) then
               if(xyz1.r(3) .gt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .le. ObsSites(loc).zpl) then
                  cross = .true.
               elseif(loc .lt. NoOfSites) then
                  if(xyz1.r(3) .gt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .le. ObsSites(loc+1).zpl) then
                     cross = .true.
                     loc = loc + 1
                     MovedTrack.where = loc
                  endif
               endif
            else
               if(xyz1.r(3) .lt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .ge. ObsSites(loc).zpl ) then
                  cross = .true.
               elseif(loc .gt. 1) then
                  if(xyz1.r(3) .lt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .ge. ObsSites(loc-1).zpl) then
                     cross = .true.
                     loc = loc - 1
                     MovedTrack.where = loc
                  endif
               endif
            endif
         endif


         if(cross) then
            MoveStat = ToBeObserved
c             get length, leng, from the starting point to
c             the observation depth
            call cdiffvec(TrackBefMove.pos.xyz, 
     *                    MovedTrack.pos.xyz, diffvec)
            call c3DV2DDCos(diffvec, diffvec, dummylen)
            if(ObsPlane .eq. horizontal) then
c                direction cos in det system
               call cxyz2detD(diffvec, dircos)
            else
c                direction cos in 1ry system
               call cxyz2primD(diffvec, dircos)
            endif

            leng = (ObsSites(loc).zpl - xyz1.r(3))/dircos.r(3)
            leng = leng + abs(0.01/dircos.r(3))
c            0.01 (=1cm) is make sure that the ptcl crosses the plane.
c           the crossing point is made to be 1 cm apart from the real level.
c     
c             reset MovedTrack
            IntInfArray(ProcessNo).length = leng
            IntInfArray(ProcessNo).thickness = clen2thick(
     *      TrackBefMove.pos.radiallen - Eradius,
     *      TrackBefMove.vec.coszenith, leng)
c
c            call ccompPathEnd  ! this call produce some error
c                                 on the crossing coordinate so we
c                          use straight line approximation here.
            MovedTrack = TrackBefMove

            call cmoveStreight(leng)

            if(MovedTrack.p.charge .ne. 0) then
               call cqElossRate(dedt) ! get de/dx computed previously
               MovedTrack.p.fm.p(4) =max( MovedTrack.p.fm.p(4) -
     *          dedt * IntInfArray(ProcessNo).thickness,
     *          MovedTrack.p.mass)   ! max is for safety. we neg. 
                                     ! syncrotron loss
            endif
c               ** next produces error due the curvature of earth
c            if(ObsPlane .eq. horizontal) then
c                if det system, below is exact.
c               MovedTrack.pos.height = ObsSites(loc).pos.height
c               MovedTrack.pos.radiallen = ObsSites(loc).pos.radiallen
c               MovedTrack.pos.depth = ObsSites(loc).pos.depth
c            endif
         endif
      endif
      end
      subroutine cdiffvec(r1, r2, diff)
c        get diff= r2-r1 as 3 D vector
#include      "Zcoord.h"
      record /coord/ r1,  r2  ! input 
      record /coord/ diff     ! output.  

      integer i

      do i = 1, 3
         diff.r(i) = r2.r(i) - r1.r(i)
      enddo
      end




