c     ****************************************************************
c     *  This should not be used at kinetic energies < Mass          *
c     *                                                              *
c     * cdedxatHE: gives -de/dx (GeV/(kg/m**2)) of mu, pi, k, p
c     *        in air  (de/dx includes knockon electron energy)
c     *    Density effect depending on the air density is considered *
c     *
c     *        -de/dx by sternheimer is computed
c     *   ********** use prededx  for making const *******
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call cdedxInAir(ptcl, rhoin, dedt)
c -- input--
c     ptcl:  record /ptcl/
c    rhoin: density of air in kg/m**3
c -- output --
c     dedt; energy loss   GeV/(kg/m**2) 
c
c
c
         subroutine cdedxatHE(aPtcl, rhoin, dedt)
         implicit none
#include  "Zptcl.h"
         record /ptcl/ aPtcl
         real*8  rhoin, dedt
c
c

         real*8 emass, emass2
         parameter (emass=.511, emass2=emass**2)
c
         real*8  ek, amass, a, b,  x0, c, x1, sa, rho, rl, e, gi
         real*8  beta2, pbmc, cb, dltx, p2, wm, wlg, x
c
c          see      sternheimer's consts. by p.r.b vol.3 (1971)3681
c                 to mev unit
         if(aPtcl.charge .ne. 0) then
              ek=aPtcl.fm.p(4) *1.e3
              amass=aPtcl.mass * 1.e3
              a=7.68e-2
              b=17.87
              if(ek .lt. 50.*amass) then
                  x0=1.884
                  c=-10.97
                  x1=4.
                  sa=.247
              else
                  rho=min( max(rhoin, 1.d-7), 5.d-3)
                  rl=log10(rho)
                  x0= (((-.0165*rl-0.305)*rl-1.94)*rl-5.41)*rl-3.87
                  c=-4.0635+2.303*rl
                  if(rho .gt. 2.78605e-4) then
                      x1=4.
                      sa=((-.6872064e-01*rl-.5340530 )*rl
     *               -1.521159 )*rl-1.365158
                  else
                      x1=5.
                      sa=(((.04256*rl+.7888)*rl+5.465)*rl+16.642)*rl+
     *                      18.855
                  endif
              endif
c                     energy in mev unit
              e=(ek+amass)
              gi=amass/e
              beta2= 1. - gi**2
c                      x=log10(p/mc)
              pbmc =      (e/amass)**2 - 1.
              if(pbmc .gt. 0.) then
                  x=log10(pbmc)/2
                  cb=-c
                  if(x .lt. x0) then
c                        4.606x - dlt
                      dltx=4.606*x
                  elseif(x .lt. x1) then
                      dltx=cb - (x1-x)**3 * sa
                  else
                      dltx=cb
                  endif
                  p2=e**2 -amass**2
                  wm=2*emass*p2/( amass**2+ emass2+ emass*e*2)
                  wlg=log(wm)
                  dedt=a/beta2 *( b+.693+wlg -2*beta2 + dltx)
c                                convert it to GeV/(kg/m2)
                  dedt=dedt *1.e-4 *aPtcl.charge**2
            else
                  dedt=1.e-9
            endif
         else
            dedt = 0.
         endif
      end
