c           need Zcoord.h  Zobs.h  Zpos.h Zmagfield.h
	integer NoOfSites           ! No of particle observation sites
        integer NoOfASSites
	real*8  XaxisFromSouth      ! in degree.  counter clockwise angle of
c                                      x-axis of 'detector' from the south
c                                      x-axis is assumed to be directed to
c                                      magnetic-east 
c          
	real*8 CosLatitude          ! oos of Latitude of deepest obs. site
        real*8 SinLatitude          ! sin
        real*8 CosLongitude         ! cos of Longitude
        real*8 SinLongitude         ! sin of ..

	record /coord/ DetZaxis     ! detector's Z axis in 'xyz' system
        record /coord/ DetXaxis     !  //        X    // 

        record /coord/ Xprimary     ! primary system x axis in 'xyz'
        record /coord/ Yprimary     ! primary system y axis in 'xyz'
        record /coord/ Zprimary     ! primary system z axis in 'xyz'
                                    ! these are computed in cprimxyz in
                                    ! ciniTracking in ceventLoop


	record /magfield/ MagfieldNED     ! mag in 'ned' at deepest obs. site
        record /magfield/ MagfieldHVA     ! mag in 'hva' at //. both in T.
        record /magfield/ MagfieldXYZ     ! mag in 'xyz' at //. both in T.

         structure /site/
               record /position/pos
               real*8  zpl           ! z value in 1ry system
               real*8  minitime
         end structure 
         structure /assite/
               record /position/pos
               real*8  zpl 
               real*8  mu             ! Moliere Unit
               real*8  esize          ! electron size
               real*8  age            ! size weighted age
         end structure

	 record /site/ ObsSites(maxNoOfSites)
         record /assite/ ASObsSites(maxNoOfASSites)
c            to store Ne, age of a component shower for an electron
         real*8 CompASNe(maxNoOfASSites), CompASAge(maxNoOfASSites)

         common /Zobsvc/  ASObsSites,  ObsSites,
     *     MagfieldNED, MagfieldHVA, MagfieldXYZ, 
     *     CompASNe, CompASAge,
     *     DetZaxis, DetXaxis, Xprimary, Yprimary, Zprimary,
     *     XaxisFromSouth, 
     *     CosLatitude, SinLatitude, CosLongitude, SinLongitude,
     *     NoOfSites,    NoOfASSites
