c     ***********************************************************
c        To know the rigidity as a function of direction at a given
c        place.
c
      subroutine crigCut(azm, zen, rigcut)
      implicit none
#include "ZrigCut.h"
c          Before calling this subroutine, you must have called
c       crigCut0 to get the table which contains the information
c       of cutoff rigidities.

c
      real*8 azm   ! input. value of azimuth angle at a given location.
                   !         deg.
      real*8 zen   ! input. value of zenith angle at a given location. 
                   !     It may be deg, or cos, depending on the table.
      real*8 rigcut ! output. value of cut-off rigidity in GV.
c
c      Note: This system cannot treat multiple locations at a time.
c
      call k4ptdi(RigCutTbl, AzmSize, ZenSize, AzmSize, MinAzm, 
     *  MinZen, DAzm,  DZen,  azm, zen, rigcut)
      end
c-------------------------        init for crigCut
      subroutine crigCut0(file)
      implicit none
#include "Zmanagerp.h"
#include "ZrigCut.h"

      character*(*) file

      character*132 msg

      integer icon

      call copenf(TempDev, file, icon)
      if(icon .ne. 0) then
         write(msg, *) ' file specification error '
         call cerrorMsg(msg, 0)
      endif
c
      read(TempDev, *)              ! skip 1st line
      read(TempDev, *) Place,  Latit,  Longi, MagDec,  AzmValue,
     *            DAzm, AzmSize, ZenValue, DZen, ZenSize

c           skip until -------------- line
      call cskipComment(TempDev, icon)
      if(icon .ne. 0) then
          call cerrorMsg('cut-off table data has no ---- line', 0)
      endif
c          see if azimuthal angle range is from 0 to 360 or from 0 to 360-DAzm

      if(AzmValue .eq. 'deg') then
c               assume min of Azimuthal angle is  0 deg.
          MinAzm = 0.
          if( (AzmSize - 1)* DAzm  .lt. (360.d0- DAzm* 0.1d0) ) then
c                 fill the last col.  by the first col.

             call creadRigCut(TempDev, RigCutTbl, AzmSize, ZenSize, 
     *       AzmSize+1)
             AzmSize = AzmSize + 1
             call cfillRigCut(RigCutTbl, AzmSize, ZenSize)
          else
             call creadRigCut(TempDev, RigCutTbl, AzmSize, ZenSize,
     *        AzmSize)
          endif

       else

          write(msg, *)
     *    ' Azimuthal angle unit must be deg for rigidity cut table'
          call cerrorMsg(msg, 1)
          write(msg, *) ' But it is ', AzmValue
          call cerrorMsg(msg, 0)
       endif

       close(TempDev)

       if(ZenValue .eq. 'cos') then
c              DZen should be negative and min is 1.0
          MinZen = 1.0
          if(DZen .ge. 0.) then
             write(msg, *)
     *        ' step of Zenith angle for rigidity cut should be < 0'
             call cerrorMsg(msg, 1)
             write(msg, *) ' because you give it in cos value'
             call cerrorMsg(msg, 0)
          endif
       endif
c
c                                   
       write(msg,*) 'Rigidity cut-off table has been read:',
     * ' place=',Place,' latitute=',Latit, ' longitude=',Longi,
     * ' mag. dec=', MagDec
       call cerrorMsg(msg, 1)
       end
c      ****************** 
       subroutine creadRigCut(io, tbl,  azm, zen, adj)
       implicit none
       integer io,  azm, zen, adj
       real*8 tbl(adj,  zen)


       integer i, j, ios
       character*100 msg

       do   j=1,  zen
           read(io,'(13f6.2)', iostat=ios) ( tbl(i, j), i = 1, azm)
           if(ios .ne. 0) then
              write(msg, *) 'Unexpected EOF at rigicity table reading'
              call cerrorMsg(msg, 1)
              write(msg, *) ' line number=', j, ' azm=',azm, ' zen=',
     *          zen, ' adj=',adj
              call cerrorMsg(msg, 0)
           endif
       enddo
       end
c      *******************
       subroutine cfillRigCut( tbl,  azm, zen)
       implicit none
       integer  azm, zen
       real*8 tbl(azm,  zen)
       integer i

        do i = 1, zen
            tbl(azm, i) = tbl(1, i)
        enddo
       end
c      ********************************** 
       subroutine cqRigCutPlace(tlt, tlg, mdec)
       implicit none
#include "ZrigCut.h"
       real*8 tlt, tlg, mdec


c            to inform lat, long, magdec
        tlt = Latit
        tlg = Longi
        mdec = MagDec
       end
