c    ******************************************************************
c    *                                                                *
c    *  cdDecay: decay of d meson into k + mu + e
c    *
c    ******************************************************************
c                   this is for prompt muon production
c  d+ ==> k0  mu+ neumu  (k0short or long)
c  d- ==> k0  mu- neumu~
c  d0 ==> k-  mu+ neumu  
c  d0~==> k+  mu- neumu~
c
      subroutine cdDecay(pj, a, np)
      implicit none
c----      include  '../../Zptcl.h'
#include  "Zptcl.h"
c----      include  '../../Zcode.h'
#include  "Zcode.h"

      record /ptcl/ pj   ! input. demeson
      integer np                ! output. # of ptcls stored in a
      record /ptcl/ a(*)  ! output. to store produced ptcls

      integer muchg, neusubc, kchg, ksubc, icon, i
      real*8 u, w

      call rndc(u)
      if(u .lt. .50) then
         ksubc = k0s
      else
         ksubc = k0l
      endif
      if(pj.charge .gt. 0) then
         muchg = 1
         kchg = 0
         neusubc =regptcl
      elseif(pj.charge .lt. 0) then
         muchg = -1
         kchg = 0
         neusubc = antip
      elseif(pj.subcode .eq. regptcl) then
         muchg = 1
         kchg = -1
         neusubc = regptcl
         ksubc = 0
      else
         muchg = -1
         kchg = 1
         neusubc = antip
         ksubc = 0
      endif
c                 muon
      call cmkptc(kmuon, 0,  muchg,  a(1))
c                 neumu
      call cmkptc(kneumu, neusubc, 0, a(2))
c                 kaon
      call cmkptc(kkaon, ksubc, kchg, a(3))
c         3  body pure phase space
      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      end

