c         test kpolintp
c
c      implicit none
c      integer n
c      parameter (n = 20)
c      real*8 xa(n), ya(n), x, y, error
c      integer i, loc, m, k
c
c      do i = 1, n
c         xa(i) = i/3.d0
c         ya(i) = exp(xa(i))
c      enddo
c      m = 5   ! use m points around x.
c      do i =1, n
c         x = xa(i) - 0.2
c         call kdwhereis(x, n, xa, 1,  loc)
c         k = min(max(loc - (m-1)/2,1), n+1-m)  ! max of m points from k
c         call kpolintp(xa(k), 1, ya(k), 1, m, x, y, error)
c         write(*, *) x, exp(x), y, error
c      enddo
c      end

c     polynomial interploation/extrapolation, based on p.103 of 
c     Numerical Recipes.  Neville's algorithm
c
      subroutine kpolintp(xa, xstep, ya, ystep, n,  x, y, error)
c   
c      integer   n. input. number of points.   
c      real*8   xa(xstep, n). input.
c      real*8   ya(ystep, n). input.  function values at xa.
c      real*8   x.  input.
c      real*8   y.  output.  interepolated functon value at x.
c      real*8  error. output. estiamted rough error.
c
      implicit none
      integer n, xstep, ystep
      real*8 xa(xstep, n), ya(ystep, n), x, y, error

      integer i, maxm
      parameter (maxm = 10)
      real*8  c(maxm), d(maxm), diff, difft

      integer ns,  m
      real*8 h0, hp, w, den

      if(n .gt. maxm) then
         write(*, *) ' kpolintp: use lesser number of points'
         stop
      endif
      ns = 1      
      diff = abs(x - xa(1, 1))
      do i = 1, n
         difft= abs(x - xa(1, i))
         if(difft .le. diff) then
            ns = i
            diff = difft
         endif
         c(i) = ya(1, i)
         d(i) = ya(1, i)
      enddo
      y = ya(1, ns)
      ns = ns-1
      do m = 1, n-1
         do i=1, n-m
            h0 = xa(1,i) -x
            hp = xa(1, i+m) - x
            w = c(i+1) - d(i)
            den = h0- hp
            den = w/den
            d(i) = hp*den
            c(i) = h0*den
         enddo
         if(2*ns .le. n-m) then
            error = c(ns+1)
         else
            error = d(ns)
            ns = ns-1
         endif
         y = y + error
      enddo
      end
