c       Zobsvp.h---parameters to be given by input.
c       This must be preceded by Zobs.h

c	(->	---------------------------------------------------

	real*8  HeightList  !1  Height of observation levels in m. This is  made from DepthList internally. 
                            ! I.e., this one is usually not an input. However, if the DepthList values are 
                            ! negative, this is used as input and corresponding DepthList is computed internally.
        real*8  DepthList   !1	Depth List of Observation level in kg/m2.  If < 0, HeightList has priority. 
                            !  (See HeightList)
        real*8  ASHeightList	!1  This is HeightList for Air Shower observ.  Used only if Generate contains
                            !  "as". See  HeightList.
        real*8  ASDepthList     !1  This is DepthList for AS observation.  Used only if Generate contains 
                            ! "as". See DepthList.
        real*8  LatitOfSite     !1  Latitude of the deepest observation level in degree.  East is positive.
        real*8  LongitOfSite    !1  Longitude of the deepest observation level in degree.  North is positive.
     	real*8  DtGMT           !1  Difference of the local time of the observation place from GMT (hour).
	real*8  YearOfGeomag    !1  Like 1994.5. Year when Geomagnetic field is to be calculated.
	integer ObsPlane        !1   How to observe particles.
                 ! 0==> no detector plane is used for observation. BorderHeightL is used to  detect particles. This is
                 !      for, say,  neutrino observation. See  BorderHeightL.  (HeigtList and   DepthList are neglected.
                 !      ASHeightList and ASDepthList are still used to  observe Air Shower.)
                 ! 1==> detector at the observation place  is horizontal.
                 ! 2==> detector is perpendicular to the primary.
                 ! 3==> detector is user defined (not supported)
        integer NoOfSites2    !2   No of Sites for particle observation; not to be touched; for skeleton/flesh use.

c	<-)	--------------------------------------------

   

        common /Zobsc/
     *	 HeightList(maxNoOfSites),
     *   DepthList(maxNoOfSites),
     *   ASHeightList(maxNoOfASSites),
     *   ASDepthList(maxNoOfASSites),
     *   LatitOfSite, 
     *   LongitOfSite, DtGMT, YearOfGeomag,
     *   ObsPlane, NoOfSites2

