c   This version is faster than cl2tT and accurracy is comparable.
c
c     *********************************************
      real*8 function clen2thickTA(z,  leng)
c
c     z: real*8. input.  vertical height in m.
c   leng: real*8. input.  length along cosz direction.
c   function value.      thickness of air in kg/m2. for leng
      implicit none
#include "Zatmos.h"
      real*8 z,  leng
      real*8  s1, t1, s2, t2

c          get slant length along cosz for z:   s1
c          get slant length ; s2 = s1 + leng
c          get thickness <-- by T vs slant length
      call cl2tIntp(HeightTbl, LenTbl, z, s1)
      call cl2tIntp(LenTbl, ThickTbl, s1, t1)
      s2 = s1 + leng
      call cl2tIntp(LenTbl, ThickTbl, s2, t2)
      clen2thickTA = t2 - t1   		
      end
c          
      subroutine cl2tIntp(x, y, xx, ans)
      implicit none
#include "Zatmos.h"

	real*8 x(*)  !  input. 
        real*8 y(*)  !  input.
        real*8  xx   !  input. some value inside x(*).
        real*8  ans  !  output.  interpolated value of y at xx.

	real*8 error
	integer  m
	integer loc, k
	parameter (m = 5)
c            where is xx in x
	call kdwhereis(xx, NumStep, x, 1, loc)
        if(loc .ge. NumStep) then
c            give arbitray large value.
  	     ans = y(NumStep)
        else
c              use max of m points around loc for interpolation
             k = min(max(loc - (m-1)/2,1), NumStep+1-m) 
                            ! max of m points from k
             call kpolintp(x(k), 1, y(k), 1, m, xx, ans, error)
	endif
        end
c         get slant length  corresponding to slant thickness
c
      real*8 function ct2lTA(z,  t)
      implicit none
#include "Zatmos.h"

      real*8 z  ! input vertical height in m
      real*8 t  !  input.  thickness of air in kg/m^2 along cosz
c
      real*8 t1, t2, s1, s2
c          z ---> thick 
      call cl2tIntp(HeightTbl, ThickTbl, z, t1)
      call cl2tIntp(HeightTbl, LenTbl,  z, s1)
      t2 = t1 + t
      call cl2tIntp(ThickTbl,  LenTbl, t2, s2)
      ct2lTA = s2- s1	
      end

