c       cxyz2det:  xyz to det
c       cdet2xyz:  det to xyz
c       cxyz2detD: xyz to det for Direction cos.
c       cdet2xyzD: det to xyz for Direction cos.
c
      subroutine cxyz2det(det, a, b)
c          convert coord value in the "xyz" system into "det" system.
c        det: /coord/  input. detector coord in "xyz"
c          a: /coord/  input. coord in 'xyz'
c          b: /coord/  outupt. coord in 'det'
c
      implicit none

#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

      record /coord/ a, b, det

      record /coord/ tempa

      real*8 len

c       coord in "xyz"   from the origin of det.
       tempa.r(1) = a.r(1) -  det.r(1)
       tempa.r(2) = a.r(2) -  det.r(2)
       tempa.r(3) = a.r(3) -  det.r(3)
c          make it direction cos.
       call c3DV2DDCos(tempa, tempa, len)
c          maket it direction cos in "det" system.
       call ciTransVectZx(1, DetZaxis, DetXaxis, tempa, b)
c          to 3D vectors
       b.r(1) = b.r(1) *len
       b.r(2) = b.r(2) *len
       b.r(3) = b.r(3) *len
       b.sys = 'det'
       end
c      *******************************
       subroutine cdet2xyz(det, a, b)
c      *******************************
       implicit none

#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

c              
        record /coord/ a, b, det
        record /coord/ tempa
        real*8 len
c           to direction cos in 'det'
        call c3DV2DDCos(a, tempa, len)
c           to direction cos in 'zyz'
        call ctransVectZx(1, DetZaxis, DetXaxis,tempa, b)
c           to xyz sys
        b.r(1) = b.r(1) *len + det.r(1)
        b.r(2) = b.r(2) *len + det.r(2)
        b.r(3) = b.r(3) *len + det.r(3)
        b.sys = 'xyz'
        end
c      -----------------------------------
        subroutine  cxyz2detD(a, b)
       implicit none

#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"


c              
        record /coord/ a, b
       call ciTransVectZx(1, DetZaxis, DetXaxis, a, b)
       b.sys = 'det'
       end
c      -----------------------------------------------------
       subroutine cdet2xyzD(a, b)
       implicit none
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

        record /coord/ a, b
        call ctransVectZx(1, DetZaxis, DetXaxis, a, b)       
        end

