      subroutine cgheDecay(a,  na, b,  nb)
c         to make particles in 'a' decay, if some of them 
c        are one of  sigma, gzai, lambda or  eta, 
c        No multistep decay is treated.  The 
c        decay product is placed in b.
c        In normal usage, if you want to get final particles
c
c        do while (.true.)
c           call cgheDecay(A, Na, B, Nb)
c           if(Na .eq. Nb) goto 10
c           call cgheDecay(B, Nb, A, Na)
c           if(Na .eq. Nb) goto 10
c        enddo
c 10     continue
c        you may use A and Na as the final decay product.
c        or B and Nb: They are the same.
c      
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      integer na   ! input. number of particles in a. 
      record /ptcl/ a(500)   ! input particle list in Cosmos format
      integer nb   ! output. nubmer of particle in b.
      record /ptcl/ b(500)  ! output.  Decay product in Comsos format.

      record /ptcl/ aPtcl
      integer i, ny

      nb = 0
      do i = 1, na
         aPtcl = a(i)
         if(aPtcl.code .eq. ksigma) then
            call csigmaDecay(aPtcl, b(nb+1), ny)
         elseif(aPtcl.code .eq. klambda) then
            call clambdaDcy(aPtcl, b(nb+1), ny)
         elseif(aPtcl.code .eq. kgzai) then
            call cgzaiDecay(aPtcl, b(nb+1), ny)
         elseif(aPtcl.code .eq. keta) then
            call cetaDecay(aPtcl, b(nb+1), ny)
         else
            b(nb+1) = aPtcl
            ny = 1
         endif
         nb = nb + ny
      enddo
      end
