#include "ZcosmosBD.h"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Ztrackp.h"


c          ///////////
      common /testcos/sumg, ng, nth, nev, nec(12)
      real*8 sumg
      integer ng, nth, nev, nec
c     //////////////

c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.
#ifdef sun4
      external csigHandler
      integer  ieeer, ieee_handler

      ieeer = ieee_handler('set', 'invalid', csigHandler)
#endif
       integer i
c
c            namelist output

        call cwriteParam(ErrorOut, 0)

c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)
      nth = 0
      nev = 0
      do i = 1, NoOfSites
         nec(i) =0
      enddo
      open(TraceDev, file='/tmp/cheren')
      end
#ifdef sun4
      integer function csigHandler(sig, code, context)
      implicit none
#include "Zmanagerp.h"
      integer sig, code, context(5)
      write(ErrorOut, *)  ' f.p exception content=' , context(4)
c      call abort()
      end
#endif

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
c          ///////////
#include "Ztrack.h"
      common /testcos/sumg, ng, nth, nev, nec(12)
      real*8 sumg
      integer ng, nth, nev, nec
      integer  remain
      record /track/ aT
c     //////////////
      integer seed(2)
c      write(*, *) ' bigin event generation'
      call cqIniRn(seed)
c      write(*,*) ' seed=', seed
      sumg = 0.
      ng = 0
      nev = nev + 1
c      call cpop(aT, remain)
c         make 4 proton beams; for check He and  4 protons
c      call cpush(aT)
c      call cpush(aT)
c      call cpush(aT)
c      call cpush(aT)
      end
  

c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c          ///////////
      common /testcos/sumg, ng, nth, nev, nec(12)
      real*8 sumg
      integer ng, nth, nev, nec
c     //////////////

c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
c      if(aTrack.p.code .eq. kmuon) then
c            output typical quantities.
c        write(*, *)   id, 
c         write(*,*)
c     *  aTrack.where,   !  observation level. integer*2.  1 is highest.
c     *  aTrack.p.code,    !  ptcl code.  integer*2.
c     *  aTrack.p.charge,  !  charge,  integer*2 
cc                        !  if TimeStructure is F, nonsense.
c     *  sngl(aTrack.p.fm.e),  ! total energy in GeV.
c     *  sngl(aTrack.pos.xyz.x), sngl(aTrack.pos.xyz.y) !  x, y in m
c     *  sngl(aTrack.t)  !  relateive arrival time in nsec (NOT sec).
c    *  sngl(aTrack.vec.w.x),  ! direc. cos.x in the current detector system.
c     *  sngl(aTrack.vec.w.y),  ! direc. cos.y
c     *  sngl(aTrack.vec.w.z),  ! direc. cos.z
c     *  sngl(aTrack.vec.coszenith) ! cos of zenith angle
c      endif
c         you may need in some case other information such as
c       aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
c                           ! ThinSampling =T)
c       aTrack.p.fm.x      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.y      !          y
c       aTrack.p.fm.z      !          z
c        if(aTrack.p.code .eq. kelec .or. aTrack.p.code .eq. kphoton) 
c        if(aTrack.p.code .eq. kelec ) then
c           nec(aTrack.where) = nec(aTrack.where) + 1
c        endif
      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"




      integer i
c          ///////////
      common /testcos/sumg, ng, nth, nev, nec(12)
      real*8 sumg
      integer ng, nth, nev, nec
c     //////////////

      if(ObserveAS) then
c                   electron size in B approx.
         do i = 1, NoOfASSites
            write(*, *) sngl(ASObsSites(i).pos.depth), 
     *      sngl(ASObsSites(i).esize), i
         enddo
c                   size weighted age
c         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites) 
      endif
c      if(ng .ge. 5 .and. sumg .ge.  10.e3) then
c         nth = nth + 1
c         write(*, *) ' #=', nth, ' ng, sumg=', ng, sumg, ' ev=',nev
c      endif
c      write(*, *) 
c      do i = 1, NoOfSites
c         write(*, *) nec(i)
c      enddo
      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"

#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"


c          ///////////
      common /testcos/sumg, ng, nth, nev, nec(12)
      real*8 sumg
      integer ng, nth, nev, nec
c     //////////////

       integer ntot, i

        call cqNoOfPrim(ntot)

c      do i = 1, NoOfSites
c         write(*,*) nec(i)/ntot
c      enddo
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 100
c     *  User should manage the trace information here.
c     * 
c     *  Default output for trace dev. can be used
c     *  for each event, of which file name is trace1, trace2
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"
#include  "Zcode.h"
       record /coord/ f, t
       logical compress/.true./
       save compress

c       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 100
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

c      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
c      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height
             


      if(TrackBefMove.p.code .eq. kmuon) then
         call ccoordForTr(Trace-100, f, t)
         call cwrtTrInfo(compress, f, t)
      endif
      end

c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat',or  'anihi'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' or 'photop'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
      end

      
