c         ready made output for cerenkov 
c         threshold dependence on the air density  is
c         taken into account.
c
       subroutine cputCerenkov
       implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackp.h"
#include "Ztrackv.h"
#include "Zcode.h"
#include "Zmass.h"
#include "Zprimary.h"
#include "Zprimaryv.h"
#include "Zheavyp.h"
#include "Zincidentv.h"
c
      real*8 crnth(kindmx)
c
c  
       real*8  thg,  thpi, thk, thmu, thnuc
       parameter (thg=40.-1., thpi=thg*maspic, thk=thg*maskc,
     1  thmu=thg*masmu, thnuc=thg*masp)
c                threshold energy in GeV at sea level
c
        record /coord/ f, t
        integer chrg, code
c
        real*8 h1, den1, e1, the
c        real*8 h2, den2, e2
        real*8 cvh2den
        logical first/.true./
        real*8 denAtSea
        save first, denAtSea
        integer ka, itb, it
        data crnth(kelec)/20.e-6/, crnth(kpion)/thpi/,
     1  crnth(kkaon)/thk/, crnth(kmuon)/thmu/,
     2  crnth(knuc)/thnuc/
        
        if(first) then
           denAtSea = cvh2den(0.d0)
           first = .false.
        endif
c          get air density.
        h1 = TrackBefMove.pos.height
        den1 = cvh2den(h1)
c        h2 = MovedTrack.pos.height
c        den2 = cvh2den(h2)
        ka = TrackBefMove.p.code
        e1 = TrackBefMove.p.fm.p(4)
c        e2 = MovedTrack.p.fm.p(4)
c
        if( ka .gt. knuc) then
           the = thnuc * Code2massN(ka)
        else
           the = crnth(ka)
        endif
c
        if( e1 .gt. the*denAtSea/den1 ) then
c               get transformed coord.
c               61-70:  --> 1ry
c               71-80:  --> 1ry but z is depth above 
c               81-90:  --> det 
c               91-100 -->  det but z is depth above
c
           call ccoordForTr(Trace-60, f, t)
           itb=TrackBefMove.t*100  ! centimeter/beta
           it=(MovedTrack.t - TrackBefMove.t)*100  !  length/beta (cm)
           chrg = TrackBefMove.p.charge
           if(mod(Trace, 2) .eq. 0 ) then
               write(TraceDev) ka, chrg, sngl(e1), itb, it, 
     *         sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)),
     *         sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3))
           else
               write(TraceDev, *) ka, chrg, sngl(e1), itb, it, 
     *         sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)),
     *         sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3))
           endif 
       endif
       return
c        *************  start of 1 shower for cerenkov trace(called from
c                      ciniTracking
c
       entry cputCerenkovS

       code = Prim.particle.code
       if(mod(Trace, 2) .eq. 0) then
           write(TraceDev) EventNo,
     *      code, 
     *      Prim.particle.fm.p(4), 
     *      AngleAtObsCopy.r(1), AngleAtObsCopy.r(2),
     *      AngleAtObsCopy.r(3)
        else
           write(TraceDev, *) EventNo,
     *      code, 
     *      Prim.particle.fm.p(4), 
     *      AngleAtObsCopy.r(1), AngleAtObsCopy.r(2),
     *      AngleAtObsCopy.r(3)
        endif
        return
c        ************** end of  1 shower
         entry  cputCerenkovE
c        ***************
         ka = 0
         chrg = 0
         e1 = 0.
         itb =0
         it =0
         f.r(1) = 0.
         f.r(2) = 0.
         f.r(3) =0
         t.r(1) = 0.
         t.r(2) = 0.
         t.r(3) = 0.
c
         if(mod(Trace, 2)  .eq. 0) then
            write(TraceDev) ka, chrg, sngl(e1), itb, it,
     *      sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)),
     *      sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3))
         else 
            write(TraceDev, *) ka, chrg, sngl(e1), itb, it,
     *      sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)),
     *      sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3))
         endif
         end
