c *******************************************************
      subroutine cmkPrimSTbl(each, icon)
c         make primary energy sampling table for a given
c         component.
c     *******************************************************
      implicit none

#include  "Zptcl.h"
#include  "Zprimary.h"
#include  "Zprimaryc.h"
      record /component/  each
      integer  icon
c
      integer k, nseg, l
c
      nseg = each.no_of_seg    ! # of segmets = datapoints -1
c         first convert flux into normal expression
c         energy unit is kept as input
c         original each flux = (dI/dE)*E**flatterer
c
c        check energy order.         
      do l = 1, nseg
         if(each.energy(l) .ge. each.energy(l+1)) then
             write(*,*) each.label,'-th component=',each.symb,
     *       ' energy is not in ascending order.'
             write(*,*) ' It is in the ', l, '-th segment'
          endif
      enddo
c         flux without multiplication of E**flatterer
      do l = 1, nseg+1
         each.flux(l) = each.flux(l)/each.energy(l)**each.flatterer
      enddo
c           now flux = dI/dE = const *E**(-beta). get beta next
      if(each.diff_or_inte .eq. 'd') then
c             get beta in E**(-beta)dE in each segment
           do k =1, nseg
              each.beta(k) = - log(each.flux(k)/each.flux(k+1))
     *                        /
     *                        log(each.energy(k)/each.energy(k+1))
           enddo
c               assume last segment extend to infinity
           if(nseg .ge. 1) each.beta(nseg+1) = each.beta(nseg)
c              make integral distribution
           if(nseg .ge. 1) then
c                 last segment to inf. integral
c                  const*E**(1-beta)/(1-beta) = flux *E/(1-beta)
              if(each.beta(nseg + 1) .gt. 1.d0) then
                   each.norm_inte(nseg+1)=
     *             each.flux(nseg+1)* each.energy(nseg+1)/
     *             (each.beta(nseg+1) - 1.d0)
              else
                   write(*,*) ' last segment power ', 
     *             each.beta(nseg+1), ' is <=1'
                   write(*,*) ' composition label=',each.label,
     *             ' component=',each.symb
                   stop 9999
              endif
           else
              each.norm_inte(nseg+1)=0.
           endif
           do k=nseg, 1, -1
              if(abs(each.beta(k)-1.d0) .gt. 1.d-6) then
                   each.norm_inte(k) = each.norm_inte(k+1) +
     *             (  each.energy(k+1)*each.flux(k+1)
     *            -each.energy(k)*each.flux(k) )/(1.d0-each.beta(k))
              else
                  each.norm_inte(k) = each.flux(k)* each.energy(k)*
     *            log(each.energy(k+1)/each.energy(k))
              endif
           enddo
       elseif(each.diff_or_inte .eq. 'i') then
c               integral. first make power of integral spectrum
           do k =1, nseg
              each.beta(k) = - log(each.flux(k)/
     *                         each.flux(k+1))
     *                  /
     *                     log(each.energy(k)/each.energy(k+1))
           enddo
           if(nseg .ge. 1) then
              each.beta(nseg + 1) = each.beta(nseg)
           endif
c               move flux into norm_inte
           do k = 1, nseg+1
               each.norm_inte(k) = each.flux(k)
           enddo
        else
           write(*,*) ' error specification of diff/integral=',
     *                each.diff_or_inte
           icon = 1
           goto 900
        endif
c          -----------------
c                total integral value
        if(nseg .ge. 1) then
              each.inte_value = each.norm_inte(1)
        else
c                  delta funcition
              each.inte_value = each.flux(1)
        endif
c               normalize the flux
        do k = 1, nseg + 1
              each.norm_inte(k) = each.norm_inte(k)/each.inte_value
        enddo
 900    continue
        end




