c    ******************************************************************
c    *                                                                *
c    *   ckaonDecay
c    *                                                                *
c    ******************************************************************
c
       subroutine ckaonDecay(pj, mupol, a,  np, polari)
       implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
c----       include '../../Zcode.h'
#include  "Zcode.h"

       integer np               !output. no. of ptcls produced
       record /ptcl/ pj         ! input. kaon
       logical mupol            ! input. if T, muon polarization is considered
       record /ptcl/ a(*)      ! output. produced ptcls
       real*8  polari         ! output. polarization of the muon.  if a containes
c                               muon. muon is put in a(np), if any.
c
c
      if(pj.charge .ne. 0) then
c           k+-
         call ckChgDcy(pj, mupol, a, np, polari)
      elseif(pj.subcode .eq. k0s) then
c           k0 short
         call ckShortDecay(pj, a, np)
      else
c           k0 long
         call ckLongDecay(pj, mupol, a, np, polari)
      endif
      end
      subroutine ckChgDcy(pj, mupol,  a, np, polari)
c
c            k+- decay
c  -- process --
c         1) k---->mu+neu         (63.5 %)
c         2)  ---->pic + pi0       21
c         3)  ---->pi0+e+neu       4.8
c         4)  ---->pi0+mu+neu      3.2
c         5)  ---->pic+pic+pic     5.6
c         6)  ---->pic+pi0+pi0     1.7
      implicit none
c
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
      
      integer np
      record /ptcl/ pj
      record /ptcl/ a(*)
      logical mupol
      real*8 polari
c
      real*8 u
      integer icp(2)/1, 0/, icm(2)/-1, 0/
      integer icp3(3)/1, 1, -1/
      integer icm3(3)/-1, 1, -1/
      integer ic3p0(3)/1, 0, 0/, ic3m0(3)/-1,0,0/
c
      call rndc(u)

      if(u  .lt. 0.635) then
c           k-->mu + neu
          call ckMuDecay(pj, mupol, a, np, polari)
      elseif(u .lt. .845) then
c           k+ --> pi+ + pi0  or  c.c
         if(pj.charge .gt. 0) then
            call ck2piDecay(pj, icp,  a, np)
         else
            call ck2piDecay(pj, icm,  a, np)
         endif
      elseif(u .lt. .893) then
c           k+ ---> pi0 +  e+ + neue
          call ckPiENeuDecay(pj, a, np)
      elseif(u .lt. .925) then
c           k+ --->mu+ + Neumu +  pi0 
         if(mupol) then
            call ckMuNeuPiDcy(pj,  a, np, polari)
         else
            call ckMuNeuPiDcy2(pj, a, np)
            polari = 0.
         endif
      elseif(u .lt. .981) then
c           k+ ---> 3*pic
         if(pj.charge .eq. 1) then
            call ck3PiDecay(pj, icp3, a, np)
         else
            call ck3PiDecay(pj, icm3, a, np)
         endif
      else
         if(pj.charge .eq. 1.) then
            call ck3PiDecay(pj,  ic3p0, a, np)
         else
            call ck3PiDecay(pj,  ic3m0, a, np)
         endif
      endif
      end
c     *******************************************
c            k0s decay
c  -- process --
c         1)  ---->pi+ + pi-       68.61%
c         2)  ---->pi0 + pi0       31.39
      subroutine ckShortDecay(pj, a, np )
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
      integer np
      record /ptcl/ pj, a(*)

      integer ic1(2)/1, -1/, ic2(2)/0, 0/
      real*8 u

      call rndc(u)
      if(u .lt. .6861) then
          call ck2piDecay(pj, ic1, a, np)
      else
          call ck2piDecay(pj, ic2, a, np)
      endif
      end
c            k0l decay
c  -- process --
c         1)  ---->e  pi neue   38.7
c         2)  ---->mu pi neum   27.1 %.    (k0==>mu+, k0bar==>mu-)
c         3)  ---->3 pi0        21.5
c         4)  ---->pi+ pi- pi0  12.4
c
      subroutine ckLongDecay(pj, mupol, a, np, polari)
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
      logical mupol
      integer np
      record /ptcl/ pj       ! kaon
      record /ptcl/ a(*)      ! outputn
      real*8 polari            ! output

      real*8 u
      integer ic(3)/0, 0, 0/, ic2(3)/1, -1, 0/
c
      call rndc(u)
      if(u .lt. .387) then
c           e  + neue + pi
          call ckPiENeuDecay(pj, a, np)
      elseif(u.lt. .658) then
c           mu + neumu + pi
          if(mupol) then
               call ckMuNeuPiDcy(pj,  a, np, polari)
          else
               call ckMuNeuPiDcy2(pj, a, np)
               polari = 0.
          endif
      elseif(u .lt. .873) then
c           3 pi0
         call ck3PiDecay(pj, ic, a, np)
      else
c           pi+ pi- pi0
         call ck3PiDecay(pj, ic2, a, np)
      endif
      end
c     ****************************************************
      subroutine ckMuNeuPiDcy(pj,  a, np, polari)
c     ****************************************************
c       k->    mu + neum + pi (parent may be k charge,or k0)
c              pi neglected       (set mu last)
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"

      integer np
      record /ptcl/ pj       ! kaon
      record /ptcl/ a(*)      ! outputn
      real*8 polari            ! output

      real*8 u, ecm, cosa, f, pcm
      integer jpa, i
c
c            make ptcl
c             k+==>pi0  mu+  nue(m)    k- ==> pi0 mu- nue_b(m)
c             k0l==> pi- mu+ nue(m) or  => pi+ mu- nue_b(m)
      if(pj.charge .eq. -1.) then
         call cmkptc(kneumu, antip, 0, a(1))
         call cmkptc(kmuon, 0, -1, a(2))
         jpa = -1
      elseif(pj.charge .eq. 1) then
         call cmkptc(kneumu, regptcl, 0, a(1))
         call cmkptc(kmuon, 0, 1, a(2))
         jpa = 1
      else
         call rndc(u)
         if(u .lt. 0.5) then
            call cmkptc(kneumu, regptcl, 0, a(1))
            call cmkptc(kmuon, 0, 1, a(2))
            jpa = -1
         else
            call cmkptc(kneumu, antip, 0, a(1))
            call cmkptc(kmuon, 0, -1, a(2))
            jpa = 1
         endif
      endif
c              sample energy of neum at rest of k
      call csampNeuEKl3(f)

      ecm=f*pj.mass
c           angle
      call rndc(u)
      cosa=2*u-1.
c          set px,py,pz
      call cpCos2pxyz(cosa, ecm, a(1).fm)
      a(1).fm.p(4) = ecm
c           muon ; should be put in the last place in a
      np=2
      call csampMuEKl3(f)
      ecm=max(f*pj.mass, a(np).mass*1.0001d0)

      pcm=sqrt(ecm**2- a(np).mass**2)

c           angle
      call rndc(u)

      cosa=2*u-1.
      call cpCos2pxyz(cosa, pcm, a(np).fm)

      a(np).fm.p(4) = ecm
      do i = 1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
c            set muon polarization
      call  cmuPolAtLabK(jpa, a(np), pj, polari)

c               pion is neglected
      end
c     ******************************
      subroutine ckMuNeuPiDcy2(pj,  a, np)
c     ******************************
c        k->   mu + neummu + pi (parent may be k charge,or k0)
c           all is considered but not polarization
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"

      integer np
      record /ptcl/ pj       ! kaon
      record /ptcl/ a(*)      ! outputn

      real*8  w, u
      integer i, icon

c           make 3 ptcls
c             k+==>pi0  mu+  nue(m)    k- ==> pi0 mu- nue_b(m)
c             k0l==> pi- mu+ nue(m) or => pi+ mu- nue_b(m)
         if(pj.charge .eq. 1) then
            call cmkptc(kneumu, regptcl, 0, a(1))
            call cmkptc(kpion, 0, 0, a(2))
            call cmkptc(kmuon, 0, 1, a(3))
         elseif(pj.charge .eq. -1) then
            call cmkptc(kneumu, antip, 0, a(1))
            call cmkptc(kpion, 0, 0, a(2))
            call cmkptc(kmuon, 0, -1, a(3))
         else
            if(pj.subcode .eq. k0l) then
               call rndc(u)
               if(u .lt. 0.5) then
                  call cmkptc(kneumu, antip, 0, a(1))
                  call cmkptc(kpion, 0, 1, a(2))
                  call cmkptc(kmuon, 0, -1, a(3))
               else
                  call cmkptc(kneumu, regptcl, 0, a(1))
                  call cmkptc(kpion, 0, -1, a(2))
                  call cmkptc(kmuon, 0, 1, a(3))
               endif
            endif
         endif
         np=3
c           3  body pure phase space
         call cnbdcy(3, pj.mass, a, 0, w, icon)
c              boost to lab
         do i = 1, np
            call cibst1(i, pj, a(i), a(i))
         enddo
      end
      subroutine ckPiENeuDecay(pj,  a, np )
c           e  + neue + pi  ; inclusive only for neue
c              
c          k+==>pi0 e+ neue;   k-==>pi0 e- neue_b
c          k0l==>pi+ e- +neue_b or ==>pi- e+ neue
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"
      
      integer np
      record /ptcl/ pj, a(*)

      real*8 u, f, ecm, cosa
c
c        make electron neu
      if(pj.charge .eq. -1.) then
         call cmkptc(kneue, antip, 0, a(1))
      elseif(pj.charge .eq. 1) then
         call cmkptc(kneue, regptcl, 0, a(1))
      else
         call rndc(u)
         if(u .lt. 0.5) then
            call cmkptc(kneue, regptcl, 0, a(1))
         else
            call cmkptc(kneue, antip,  0, a(1))
         endif
      endif
c              sample energy of neue at rest of k
      call csampNeuEKl3(f)
      ecm=f*pj.mass
c           angle
      call rndc(u)
      cosa=2*u-1.
c          set px,py,pz
      call cpCos2pxyz(cosa, ecm, a(1).fm)
      a(1).fm.p(4) = ecm
      np=1
      end
c    ******************************************************************
c    *   ckMuDecay:   k -> mu + neumu
c    ******************************************************************
c
c
c     decay of k ---> mu + neu ( b.r=.635 ) is treated.
c
      subroutine ckMuDecay(pj, mupol,  a, np, polari)
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"
      
      integer np
      record /ptcl/ pj  ! input. kaon
      record /ptcl/ a(*)  ! output. ptcls produced
      logical mupol     ! input.  T==>  muon polarization taken into acc.
      real*8 polari     ! output. muon polarizaton.
c                         muon must be put a(np).
      integer charge, subcode
c
c
      
c             make muon neutrino : muon set last
      subcode =  -pj.charge
      call cmkptc(kneumu, subcode, 0, a(1))
c             make muon
      charge = pj.charge
      call cmkptc(kmuon, 0, charge, a(2))
c
c           k-->mu + neu
      call c2bdcy(pj, a(1), a(2))
c               set polarization of muon
      if(mupol) then
         call ckmuPolari(pj, a(2),  polari)
      else
         polari=0.
      endif
      np=2
      end
c     **************************************
      subroutine ck2piDecay(pj, ic,  a, np )
c     **************************************
c            k--> 2 pi (k+-->pi+ pi0 or k- --> pi-  pi0)
c                      (k0-->pi+ pi- or k0 --> pi0 +pi0)
      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"
      
      integer np, ic(2)
      record /ptcl/ pj, a(*)
      call cmkptc(kpion, 0, ic(1), a(1))
      call cmkptc(kpion, 0, ic(2), a(2))

      call c2bdcy(pj, a(1), a(2))
      np=2
      end
c     **************************************
      subroutine ck3PiDecay(pj, ic, a, np )
c     **************************************
c          k--> 3 pi;

      implicit none
c----      include '../../Zptcl.h'
#include  "Zptcl.h"
c----      include '../../Zcode.h'
#include  "Zcode.h"
      
      integer np, ic(3)
      record /ptcl/ pj, a(*)
      
      real*8 w
      integer icon, i
c
      call cmkptc(kpion, 0, ic(1), a(1))
      call cmkptc(kpion, 0, ic(2), a(2))
      call cmkptc(kpion, 0, ic(3), a(3))
      call cnbdcy(3, pj.mass, a, 0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      end
