c       ****************************************************************
c       *
c       * csampNeueEMu:  sample energy of electron neutrino from mu decay
c       *
c       **************************tested 88.07.26***************k.k*****
c
c /usage/   call csampNeueEMu(f)
c   f: output. real*8.  sampled fractional energy.  f is the
c                       fraction  given by f=2*e'/m  where e' is the
c                       energy in muon rest system and m the muon mass.
c
          subroutine csampNeueEMu(f)
          implicit none
          real*8 f, f0
          integer l, i
c             f for u=0 to 1 step .01
      real*8  fa1(101), u
      data (fa1   (i),i=   1,  72)/
     1 0.0000, 0.1408, 0.1794, 0.2070, 0.2294, 0.2486, 0.2655, 0.2809,
     2 0.2950, 0.3081, 0.3205, 0.3320, 0.3431, 0.3536, 0.3637, 0.3734,
     3 0.3828, 0.3919, 0.4007, 0.4092, 0.4175, 0.4256, 0.4335, 0.4413,
     4 0.4489, 0.4563, 0.4636, 0.4708, 0.4778, 0.4847, 0.4916, 0.4983,
     5 0.5050, 0.5115, 0.5180, 0.5244, 0.5308, 0.5370, 0.5432, 0.5494,
     6 0.5555, 0.5615, 0.5675, 0.5735, 0.5794, 0.5853, 0.5912, 0.5970,
     7 0.6028, 0.6085, 0.6143, 0.6200, 0.6257, 0.6314, 0.6370, 0.6427,
     8 0.6483, 0.6540, 0.6596, 0.6652, 0.6708, 0.6765, 0.6821, 0.6877,
     9 0.6934, 0.6990, 0.7047, 0.7104, 0.7161, 0.7219, 0.7276, 0.7334/
      data (fa1   (i),i=  73, 101)/
     1 0.7392, 0.7451, 0.7510, 0.7570, 0.7630, 0.7691, 0.7752, 0.7814,
     2 0.7877, 0.7941, 0.8005, 0.8071, 0.8138, 0.8206, 0.8276, 0.8348,
     3 0.8421, 0.8496, 0.8575, 0.8656, 0.8741, 0.8830, 0.8924, 0.9025,
     4 0.9135, 0.9257, 0.9399, 0.9582, 1.0000/
c
          call rndc(u)
          if(u .lt. .01) then
              f0=0
               do   i=1, 2
                 f0=(u/4+.75*f0**4)**.3333333
               enddo
              f=f0
          else
              l=u*100.+1
              f=(fa1(l+1)-fa1(l))*100.*(u-(l-1)/100.) + fa1(l)
          endif
          end
