#include "ZsaveStruc.h"
cc           to test clorep.
c      include 'cgetRotMat4.f'
c      include 'cmkptc.f'
c      include 'cpm2e.f'
c      include 'clorez.f'
cc       ----------------------------
c      implicit none
c      include '../Zptcl.h'
c      include '../Zcode.h'
c      record /ptcl/ p, q, r
c      record /fmom/ gb, gbn
c      real*8  g, gba, bx, by, bz
c      integer i, j
c      g=1.d0
c      do  j=1, 45
c         gba=g*sqrt(1.d0-1.d0/g/g)
c         bx=-sqrt(2.d0)/2.d0
c         by=sqrt(2.d0)/5.d0
c         bz=-sqrt(1.d0 - bx**2 - by**2)
c         gb.p(1)=bx*gba
c         gb.p(2)=by*gba
c         gb.p(3)=bz*gba
c         gb.p(4)=g
c         do i=1, 3
c            gbn.p(i)=-gb.p(i)
c         enddo
c         gbn.t=g     
c         p.fm.p(1)=10.d0
c         p.fm.p(2)=10.d0
c         p.fm.p(3)=10000.d0
c         call cmkptc(knuc, 0, 1, p)
c         call cpm2e(p, p)
c         do i=1, 1
c            call clorep(i, gb, p, q)
c         enddo
c         write(*,*) ' after clorep q=',q.fm.p
c         call clorep(1, gbn, q, r)
c         write(*,*) ' --------g=', g
c         write(*,*)  ( (p.fm.p(i)-r.fm.p(i))/p.fm.p(i), i=1, 4)
c         g = g * 10.d0**.25
c      enddo   
c      end
c       **************************************************************
c       *
c       *    clorep: general Lorentz transformation
c       *           (vector defining axes are paralell in both systems).
c       *
c       **************************************************************
c
c /usage/   call clorep(j, gb, q,  p)
c
c          suppose a system (K') moving with a velocity beta
c          (3-d vector) and gamma factor g relative to another
c          systeme (K).  q is  4 momenta given in
c          the frame K' (of which x,y,z axies are parallel to
c                       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c          those of the system K).  This routine gives
c          ~~~~~~~~~~~~~~~~~~~~~
c          4 momenta, p, seen from the K-system.
c
c          4 moemnta are assumed to be in the order of (px, py,
c          pz, e)
c
c     j: input. integer*4   j=1--->gb are new
c                           j^=1-->gb are the same as previous
c                                  values.
c gb: /fmom/  input.  (g*beta, g).
c  q: /ptcl/  input.   4 momenta and mass of a ptcl
c  p: /ptcl/  output.  transformed 4 one.
c                        (p may be the same one as q)
c
c        If we apply the formula directly for gb*q < 0 case at
c        very high  energy,
c        subtraction mig.p(4) result in complete loss of accuracy.
c        To get rid of this, q is converted to a system whose z-axis
c        coinsides with beta and lorentz transformation is applied
c        for the z-direction.  After that, the vector is ratoted
c        so that z axis be parallel to that of the K-system.
c
c        If beta is completely parallel to the z axis, use
c        clorez(;faster).
c
c   Accuracy is better than 7 dig.p(4)s in normal applicaltion
c      (g upto 10e12).
c
       subroutine clorep(j, gb, q, p)
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"

         record /fmom/ gb
         record /ptcl/ q, p
c
         real*8 rm(4, 4), rmy(4, 4), rmyi(4, 4), rmz(4, 4),
     *          rmzi(4, 4),  rmi(4, 4), gmin/1.e4/, g
         real*8 fai1, fai2,  tmp,  gbq, a
         record /fmom/ agb
         record /ptcl/ qt

#ifdef   USESAVE
         save agb
#endif

         integer jsv/0/, i, j
         save  rm, rmi, jsv
c

          gbq = 0.d0
          do   i=1, 3
            gbq=gbq + gb.p(i)*q.fm.p(i)
          enddo
c
         g = gb.p(4) 
         a=1.d0/(1.d0+g)
         if(gbq .ge. 0.d0 .or. g .lt. gmin) then
c         if(gbq .ge. 0.d0 ) then
              do   i=1, 3
                p.fm.p(i) = q.fm.p(i) + 
     *                      gb.p(i)*(q.fm.p(4) + a*gbq)
              enddo
             p.fm.p(4) = g*q.fm.p(4) + gbq
c               j=1, but matrix is not computed
             if(j .eq.1) jsv=0
         else
c              rotate the axes by atan(beta(y)/beta(x)) around z,
c              then rotate the axes by  atan(beta/beta(z))
c              around y, then the orignal z axis coincide with
c              beta.  apply lorentz trans. there and re-rotate
c                 matrix for z-axis
             if(j .eq. 1 .or. jsv .eq. 0) then
                 if(gb.p(2) .eq. 0. .and. gb.p(1) .eq. 0.) then
                     fai1=0.
                 else
                     fai1= atan2(gb.p(2), gb.p(1))
                 endif
                 call cgetRotMat4(3, fai1, rmz)
c                     matrix for y-axis
                 tmp=gb.p(1)**2 + gb.p(2)**2
                 agb.p(3)= sqrt(tmp + gb.p(3)**2)
                 agb.p(4)=g
                 fai2= atan2(sqrt(tmp), gb.p(3))
                 call cgetRotMat4(2, fai2, rmy)
c                     combined rotaion matrix
                 call cmultRotMat4(rmy, rmz, rm)
             endif
c                 do combined rotaion
             call capplyRot4(rm, q.fm, qt.fm)
             qt.fm.p(4)=q.fm.p(4)
             qt.mass = q.mass
c           ////////////
c             call ctestOnShell('q before rot', q)
c             call ctestOnShell('qt after rot', qt)
c           ////////////////                      

c                   lorentz trans. along beta
             call clorez(agb, qt,  qt)
c           /////////
c             call ctestOnShell('after lorez', qt)
c           /////////////
c                   re-rotate; get inverse rotation matrix
             if(j .eq. 1 .or. jsv .eq. 0) then
                 call cinvRotMat4(rmz, rmzi)
                 call cinvRotMat4(rmy, rmyi)
                 call cmultRotMat4(rmzi, rmyi, rmi)
             endif
             call capplyRot4(rmi, qt.fm, p.fm)
             p.fm.p(4) = qt.fm.p(4)
c           ////////////
c             call ctestOnShell('after rot', p)
c           ////////////////                      
             jsv=1
          endif
      end
