      subroutine cifXObsSite
c         see if MovedTrack crosses an observation depth.
c         or go out of boundry.
c        if to be observed, reset MovedTrack information
      implicit none
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zearth.h"
c     
      integer loc
      real*8  leng, temp, dedt
      real*8  clen2thick
c               , clenbetween2h
      logical cross
      record /coord/ xyz1, xyz2, dircos

c
c            see if go out of outer boundery.
      call cscalerProd(MovedTrack.vec.w, DcAtObsXyz, temp)
      if(temp .lt. BackAngLimit .or.
     *   MovedTrack.pos.height .gt. BorderHeightH) then
c             discard it
         MoveStat = BorderH
         return  !  ***************
      endif
c  -------------------------------------------------------------

      loc = MovedTrack.where 
      if(MovedTrack.pos.height .lt. BorderHeightL) then
         MoveStat = BorderL
c         leng = clenbetween2h(TrackBefMove.pos.height+Eradius,
c     *         BorderL+Eradius, TrackBefMove.vec.coszenith)
      endif
      if(ObsPlane .ne. notUsed ) then
         if(ObsPlane .eq. horizontal) then
c                  horizontal
            call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
         elseif(ObsPlane .eq. perpendicular) then
c           observation plane is perpendicular to primary
c           convert coord into 1ry system
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
         endif
         cross = xyz2.r(3) .le. ObsSites(loc).zpl
         if(cross) then
            MoveStat = ToBeObserved
c             get length, leng, from the starting point to
c           the observation depth
            if(ObsPlane .eq. horizontal) then
c               starting point in det system
               call cxyz2det(ObsSites(NoOfSites).pos.xyz,
     *         TrackBefMove.pos.xyz, xyz1)
c                direction cos in det system
               call cxyz2detD(TrackBefMove.vec.w, dircos)
            else
c               starting point in 1ry system
               call cxyz2prim(ObsSites(NoOfSites).pos.xyz,
     *         TrackBefMove.pos.xyz, xyz1)
c                direction cos in 1ry system
               call cxyz2primD(TrackBefMove.vec.w, dircos)
            endif
            leng = (ObsSites(loc).zpl - xyz1.r(3))/dircos.r(3)
         endif

         if(cross) then
c             reset MovedTrack
            IntInfArray(ProcessNo).length = leng
            IntInfArray(ProcessNo).thickness = clen2thick(
     *      TrackBefMove.pos.radiallen - Eradius,
     *      TrackBefMove.vec.coszenith, leng)
c
c            call ccompPathEnd  ! this call produce some error
c                                 on the crossing coordinate so we
c                          use straight line approximation here.
            MovedTrack = TrackBefMove

            call cmoveStreight(leng)

            if(MovedTrack.p.charge .ne. 0) then
               call cqElossRate(dedt) ! get de/dx computed previously
               MovedTrack.p.fm.p(4) =max( MovedTrack.p.fm.p(4) -
     *          dedt * IntInfArray(ProcessNo).thickness,
     *          MovedTrack.p.mass)   ! max is for safety. we neg. 
                                     ! syncrotron loss
            endif
            if(ObsPlane .eq. horizontal) then
c                if det system, below is exact.
               MovedTrack.pos.height = ObsSites(loc).pos.height
               MovedTrack.pos.radiallen = ObsSites(loc).pos.radiallen
               MovedTrack.pos.depth = ObsSites(loc).pos.depth
            endif
         endif
      endif
      end



