c           test cpairLPMXsec
c      implicit none
c      integer j, i
c      real*8  rho, e, xs
c      do  j=1, 11
c          rho=1. * 10.**(-(j-1)/2.)
c          do i=1, 14
c             e=1.e8 * 10.**( (i-1)/3.0)
c             call cpairLPMXsec(e, rho, xs)
c             write(*, *) sngl(e), sngl(xs)
c          enddo
c          write(*, *)
c      enddo 
c      end
       subroutine cpairLPMXsec(eg, rhoin, xs)
       implicit none
c          compute pair creation probability of very high energy
c          gamma rays in air.   Landau effect is taken into account
c    eg.  input.   gamma energy in gev.   5.e8 < eg < 1.e13
c   rhoin.input.   air density in kg/m**3   
c    xs.  output.  probability  /r.l
c        
c         input outside of this range will be accepted 
c         properly.
c  
c
        real*8  eg, rhoin, xs
c
c       Since the probability of pair creation f(v, Eg, rho)dv
c      (v = Ee/Eg) scales as f(v, Eg*rho)dv,
c      we made an approximate formula for f(v, x)dv for x
c      =1 to 10^10 GeV*gm/cm3
c
        real*8 x, xlog
        integer i
        real*8 xxx(6)
        data ( xxx(i), i=  1,   6)/
     1       59.363582    ,  -19.567178    ,   2.4813214    ,
     2  -0.15128851    ,  0.44302046E-02, -0.50465366E-04               
     * /   
    
       x = eg* rhoin * 1.e-3   !  GeV g/cm3
       if(x .lt. 1.e5) then
           xs = 0.777
       elseif(x .lt. 1.e10) then
           xlog = log(x)
           xs = 0.
           do i =6, 2, -1
              xs =(xs + xxx(i))* xlog
           enddo
           xs = xs + xxx(1)
           xs = exp(xs)
       else
           xs = 2.12e-2 * (x/1.e10)**(-0.5)
       endif

       end
