c          cxyz2prim:  xyz to primary system coord. conversion
c          cxyz2primD: xyz to primary system for Direction cos. 
c
      subroutine cxyz2prim(base, a, b)
      implicit none
c
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

c                                  origin of primary system is the
c                                  origin of this deepest detector
      record /coord/ base ! base detector coord. whose origin is the
                          ! origin of 1ry system.
      record /coord/ a   ! input.  coord. in 'xyz'
      record /coord/ b   ! output. transformed coord. in 'prim'

      record /coord/ tempa


c       coord in "xyz"   from the origin of det.
       tempa.r(1) = a.r(1) - base.r(1)
       tempa.r(2) = a.r(2) - base.r(2)
       tempa.r(3) = a.r(3) - base.r(3)
       call cscalerProd(tempa, Xprimary, b.r(1))
       call cscalerProd(tempa, Yprimary, b.r(2))
       call cscalerProd(tempa, Zprimary, b.r(3))
       b.sys = 'prim'
       end
c      -----------------------------------
       subroutine cxyz2primD(a, b)
      implicit none
c
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

       record /coord/a, b

       call cscalerProd(a, Xprimary, b.r(1))
       call cscalerProd(a, Yprimary, b.r(2))
       call cscalerProd(a, Zprimary, b.r(3))
       b.sys = 'prim'
       end
