c         hadoron-A collision of my adhoc model.
      subroutine chAcolAdhoc(pj, ia, iz, a, ntp)
      implicit none
c          This is a Adhoc model of multiple production.
c          h-A collision is decomposed into multiple collision
c          of the leading particle, and for each collision
c          chncol is used with some reduction of the leading
c          particle energy for the 2nd, 3rd,... collisions.
c          Since the incident energy is high, we neglect
c          the multiple collisions at energy < 5 GeV.
c

#include  "Zptcl.h"
#include  "Zcode.h"

c
      record /ptcl/ pj   ! input  projectile ptcl
      integer ia    ! input. mass no. of target
      integer iz    ! input. charge no. of target
      record /ptcl/ a(*)  !  output. produced ptcls
      integer ntp   ! number of produced ptcls
c
      integer ncoll, tgtchg, i, n
      record /ptcl/ aPtcl,  tgt
      real*8  eminSucCol/5./
      integer icon
c
c          Fermi momentum can be neglected ( E > Elund= 500 GeV)
         call csampCollInA(pj, ia, ncoll)
c            fix target nucleon charge
         call cfxTgtChg(ia, iz, tgtchg)
c                make target nucleon
         call cmkptc(knuc, regptcl, tgtchg, tgt)
c              give 4 momentum
         tgt.fm.p(1) = 0.
         tgt.fm.p(2) = 0.
         tgt.fm.p(3) = 0.
         tgt.fm.p(4) = tgt.mass
c         
         call chncol(pj, tgt, a, ntp, icon)
         if(icon .ne. 0) goto 100
         call cslpx2(.true.)      ! specify that this is 2nd,3rd .. col.
         do i = 2, ncoll
c                extract leading ptcl
            aPtcl = a(ntp)
            if(aPtcl.fm.p(4) .gt. eminSucCol) then
                  ntp = ntp - 1
                  call cfxTgtChg(ia, iz, tgtchg)
                  tgt.charge = tgtchg
                  call chncol(aPtcl, tgt, a(ntp+1), n, icon)
                  if(icon .ne. 0) then
                     ntp = ntp + 1
                     a(ntp) = aPtcl
                     goto 50
                  endif
                  ntp = ntp + n
             endif
         enddo 
 50      continue 
         call cslpx2(.false.)  ! reset nucleus condition 
 100     continue
      end
