c       mu---> e + neue + neumu; inclusive treatment only if polarization
c                   is non 0.
c              if polarization is 0, 3 body pure phase space is used.
      subroutine cmuNeuDcy(pj, polari, a, np)
      implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
      
      integer np     ! output.  no. of produced particles
      real*8 polari  ! input.   muon polarization
      record /ptcl/pj  ! input. muon
      record /ptcl/ a(*)  ! output.  produced ptcls
c
      real*8 po, f, ecm, cosa, w, e
      integer icon, i, charge, subcode
c
c           make 3 ptcls
      subcode = -pj.charge
      call cmkptc(kneue, subcode, 0, a(1))
      subcode = pj.charge
      call cmkptc(kneumu, subcode, 0, a(2))
      charge = pj.charge
      call cmkptc(kelec, 0, charge,  a(3))
      if(polari .eq. 0.) then
         call cnbdcy(3, pj.mass, a, 0, w, icon)
         np = 3
      else
         if(pj.charge .eq. 1) then
c                for mu+, polarization should be made to inverse sign
c                because e+ goes same as mu+ polarizaion while
c                neue trino opposit.
            po=-polari
         else
            po=polari
         endif
c           sample energy in f=2e*/mmu: e* is at muon rest sytem
c           of neue
         call csampNeueEMu(f)
         ecm=f*pj.mass/2
c              sample decay angle of neue at muon rest system
         call csampNeueCos(po, cosa)
c              set random momentum about azimuth (px,py,pz)
         call cpCos2pxyz(cosa, ecm, a(1).fm)
         a(1).fm.p(4) = ecm
c                 since inclusive, no conservation tried
c          neumu; sample energy in f=2e*/mmu: e* is at muon rest sytem
         call csNeumuEMu(f)
         ecm=f*pj.mass/2
c              sample decay angle of neumu at muon rest system
         call csampNeumuCos(po, f, cosa)
c             set px,py,pz
         call cpCos2pxyz(cosa, ecm, a(2).fm)
         a(2).fm.p(4) = ecm
c                    boost
c               electron is added only if it's energy >0.
         e=pj.mass-a(1).fm.p(4)-a(2).fm.p(4)
         if(e .gt. a(3).mass) then
            np=3
            a(3).fm.p(4) = e
            a(3).fm.p(1) = -(a(1).fm.p(1) + a(2).fm.p(1))
            a(3).fm.p(2) = -(a(1).fm.p(2) + a(2).fm.p(2))
            a(3).fm.p(3) = -(a(1).fm.p(3) + a(2).fm.p(3))
            call cadjm(a(3), a(3))
         else
            np=2
         endif
      endif
c               boost to lab.
      do i = 1, np
         call cibst1(i, pj, a(i), a(i) )
      enddo
      end
