cc         testing clorez
c      include 'cpxyzp.f'
c      include 'cmkptc.f'
c      include 'cpm2e.f' 
cc -----------------------
c      implicit none
c      include '../Zptcl.h'
c      include '../Zcode.h'
c      record /ptcl/ p, po
c      record /fmom/  gb, gbi
c      real*8  g
c      integer i, j
c       g=1.
c       call cmkptc(knuc, 0, 1, p)
cc
c       do  i=1, 50
c           p.fm.p(1)=1.5d0
c           p.fm.p(2)=-8.5e1
c           p.fm.p(3)=5.e4
c           call cpm2e(p, p)
c           gb.p(1)=0.
c           gb.p(2)=0.
c           if(g .lt. 1.d4)then
c              gb.p(3)= g * sqrt(1.-1./g/g)
c           else   
c              gb.p(3)= g* (1.  -  1./g/g/2)
c           endif   
c           gb.p(4)= g
c           gbi.x=0.
c           gbi.y=0.
c           gbi.z=-gb.p(3)
c           gbi.t=g
c           call clorez( gb, p,  po)
c           call clorez( gbi, po,  po)
c           write(*,*) g,
c    *            ( (p.fm.p(j)-po.fm.p(j))/p.fm.p(j),j=3, 4)
c           g=g*10.d0**.25
c       enddo    
c       end
c       **************************************************************
c       *
c       * clorez: Lorentz transformation in z direction.
c       *         relative accuracy is better than 10 digts
c       *
c       **************************************************************
c
c /usage/  call clorez(gb, p,  po)
c
c        Suppose two systems K and K'.  K' is moving with a
c        constant velocity relative to K (4 velocity is 
c        in gb).  The axises in the both system are parallel.
c        K' is moving along the direction of the z axis.
c        (i.e., gb=(0, 0, gb(3), gamma)).
c        p is a 4 momentum given in K'.  This routine
c        transforms p into po seen from K.
c    gb(4): Input. real*8 (g*beta, g) of K' system seen from K. 
c     p(4): Input. real*8. 4  momentum of a ptcl in K'.
c               p(1)=px', p(2)=py', p(3)=pz', p(4)=e'
c    po(4): Outut.  real*8. 
c           4 momentum seen from K.
c           po(1)=px', po(2)=py', po(3)=pz,  po(4)=e  
c           po can be the same array as p.
c
       subroutine clorez(gb, p, po)
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
         record /fmom/ gb
         record /ptcl/  p, po
c
         real*8 eps, gmin
         parameter (gmin=1.d4, eps=2.d0/gmin/gmin)
         real*8 bpp, ex, tm2, x,  g, ge, tmbye2
         real*8 eta /1.d-4/
c
         po.fm.p(1) = p.fm.p(1)
         po.fm.p(2) = p.fm.p(2)
         bpp = gb.p(3)*p.fm.p(3)
         g = gb.p(4)
c     
         ge = g*p.fm.p(4)
         ex =  ge+bpp
         if(abs( ex / ge ) .gt. eta ) then
              po.fm.p(3) = g*p.fm.p(3) + gb.p(3) * p.fm.p(4)
              po.fm.p(4) = ex
         else
c                  transverse mass square
              tm2=p.fm.p(1)**2 + p.fm.p(2)**2 + p.mass**2
              tmbye2 = tm2 / (p.fm.p(4))**2
              
              x= 1./g**4/4. + tmbye2**2/4. - tmbye2/g**2/2.
     *          + tmbye2 + 1./g**2
              ex = g * p.fm.p(4) * x /2
              x =-sign( (1.d0 + 0.25d0* tmbye2)*tmbye2, p.fm.p(3)) 
     *            - sign( (1.+ 0.25d0/g**2)/g**2, gb.p(3))
              po.fm.p(3) = g * p.fm.p(4) * x /2
              po.fm.p(4) = ex
         endif
       end




