      subroutine ciniTracking
c          this is called after primary is fixed.
      implicit none

#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackp.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"

      external cxyz2prim, cxyz2det
      integer klena, leng
      character*70 tracefile

      Zfirst = 0.

c 
      if(Job .eq. 'flesh') then
         call csetEmin(Generate2, KEminObs2, KEmin2, KEminCas2)
         call csetEmin(Generate, KEminObs, KEmin, KEminCas)
      else
         call csetEmin(Generate, KEminObs, KEmin, KEminCas)
         KEmin2 = KEmin
         KEminCas2 = KEminCas
      endif


      call cprimxyz   ! compute primary x,y,z axis in 'xyz' system
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. Trace .gt. 100) then
c            default trace output is requested. Open disk file
         write(tracefile, *) TraceDir(1:klena(TraceDir))//'/trace',
     *         EventNo
         call kseblk(tracefile, ' ', leng)
         open(TraceDev, file=tracefile(1:leng), form='formatted')
      elseif(Trace .gt. 60 .and. Trace .lt. 100) then
         call cputCerenkovS     ! cerenkov output header for each event
      endif
c
      call ciniASObs
      if(ObsPlane .eq. horizontal ) then
         call csetObsZ(cxyz2det)
      elseif(ObsPlane .eq. perpendicular ) then
         call csetObsZ(cxyz2prim)
      elseif(ObsPlane .eq.  notUsed ) then
c           Nothing to do. observation is at height =
c           BorderHeighL. (for neutrino)
      else
         call cerrorMsg('ObsPlane value is wrong', 0)
      endif
c         check some parameters
      call  cexamParam
      end
c     --------- compute primary system, x,y,z.  
c               The deepest detector is the reference.
      subroutine cprimxyz
      implicit none
#include "Ztrack.h"
#include "Zincidentv.h"
#include "Zobs.h"
#include "Zobsv.h"
c           all are unit vector in 'xyz' system.
c
c        X = Z x V  ( Z  is primary direction; V is vertical axis )
c          =  V x(-Z)
c          =  V x DcAtObsXyz = DetZaxis.r(1) DcAtObsXyz
c        Y = Z x X  = X x (-Z)
c          = X x DcAtObsXyz
c              
c      compute Xprimary, Yprimary, Zprimary in 'xyz' system.

      real*8  temp
c      
      Zprimary.r(1) = - DcAtObsXyz.r(1)
      Zprimary.r(2) = - DcAtObsXyz.r(2)
      Zprimary.r(3) = - DcAtObsXyz.r(3)
      call cvecProd(Zprimary, DetZaxis, Xprimary)
c         see if Zprimary // DetZaxis; if so reset Xprimary
      temp= Xprimary.r(1)**2 + Xprimary.r(2)**2 + Xprimary.r(3)**2
      if(temp .lt. 1.e-12) then
         Xprimary = DetXaxis
      else
         temp =sqrt(temp)
         Xprimary.r(1) = Xprimary.r(1)/temp
         Xprimary.r(2) = Xprimary.r(2)/temp
         Xprimary.r(3) = Xprimary.r(3)/temp
      endif
      call cvecProd(Zprimary, Xprimary, Yprimary)
      end
c     ******************************
      subroutine csetObsZ(converter)
c     *****************************
c      compute Z of observation plane 
c      
      implicit none
#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      external converter  ! cxyz2prim or cxyz2det
c                           depending on ObsPlane =2, 1
      integer i
      record /coord/ temp
c        compute z from the base detector.
      do i = 1, NoOfSites
         call converter(ObsSites(NoOfSites).pos.xyz, 
     *     ObsSites(i).pos.xyz,
     *     temp)
         ObsSites(i).zpl = temp.r(3)
      enddo
c            this is for A.S
      do i = 1, NoOfASSites
         call converter(ASObsSites(NoOfASSites).pos.xyz, 
     *     ASObsSites(i).pos.xyz,
     *     temp)
         ASObsSites(i).zpl = temp.r(3)
      enddo
      end
c      **************************
      subroutine cqFirstID(depth)
c         inquire the first interaction depth
      implicit none

#include "Ztrack.h"
#include "Ztrackv.h"
      real*8 depth   ! output. to get the first I.D
      
      depth = Zfirst   ! vertical depth
      end

c --------------------------------
      subroutine ciniASObs
      implicit none

#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      integer i

      do i = 1, NoOfASSites
         ASObsSites(i).esize = 0.
         ASObsSites(i).age = 0.
      enddo
      end
c     ***********************
      subroutine  csetEmin(gen, eminob,  emin, emCas)
c     ***********************
      implicit none
#include  "Zmanagerp.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zheavyc.h"
#include  "Zheavyp.h"
c
      character*(*)  gen ! input. a copy of Generate. 
      real*8  eminob   !   input. minim observational energy (kientic)
      real*8  emin     !  output. Minimum energy to be followed for non e-g
                       !  ptcls.
      real*8  emCas    !  output. Minimum energy to be followed for e-g
c
c
      real*8  ergpn    ! energy / nucleon
      logical cas      ! 
      logical obas     ! 

c
      cas = index(gen, 'em') .gt. 0 
      obas = index(gen, 'as') .gt. 0 .or.
     *   index(gen, 'lat') .gt. 0
!
      if(obas ) then
c          energy / nucleon for heavy
         if(IncidentCopy.p.code .ge. kdeut .and.
     *         IncidentCopy.p.code .le.  khvymax) then
            ergpn =
     *       IncidentCopy.p.fm.p(4)/Code2massN(IncidentCopy.p.code)
         else
            ergpn = IncidentCopy.p.fm.p(4)
         endif
         EminAS=max(1.d0, ergpn*RatioToE0)   ! if Ee < E0*RatioToE0 or 
               ! if < 1 GeV, neglect AS generation
               ! wait until electon  energy becomes < EasGen for a.s
               ! generation. WaitRatio < 1 should be used when 1ry is 
               ! g or e.   (say, 0.01)
c         EasWait =max(ergpn * WaitRatio, EminAS*10.0)
         EasWait =max(ergpn * WaitRatio, EminAS*100.0)   ! 95/08/17
      else
         EminAS = 1.d30
      endif

      emin = eminob

      if(obas) then
c         emCas = min( EminAS, emin) 
c         emin = emCas
	  emin = min(EminAS, emin)     ! 95/0817/
          emCas =min(max(1.d0, emin/30.), emin)   ! //
      elseif(cas) then
         emCas = emin
      else
         emCas = 1.d30
      endif


      if(ThinSampling) then
c           thin sampling
           Ethin = EthinRatio*ergpn
      else
           Ethin = 0.
      endif
      end
      subroutine cexamParam
      implicit none
#include "Ztrackp.h"
#include "Zelemagp.h"

      end
