c     clen2thick
c
c     Thickness of air corresponding to a given length along
c     a given direction from a given height.
c
c        test program
c     include 'catmosutil.f'
c     include 'cstdatmos0.f'
c     include '../../KKlib/k16pGaussLeg.f'
c
c     program testclen2thick
c     implicit none
c     real*8 z, cosz, len, thick, thicka
c
c     real*8 clen2thick
c
c     z = 6000.
c     cosz = 1.
c     len = 3000.
c     write(*, *) " enter z, cosz, len=",z, cosz, len
c     read(*,*) z, cosz, len
c     thick = clen2thick(z, cosz, len)
c     write(*, *) " thick = ", thick
c     end
c     ========================================
      real*8 function clen2thick(z, cosz, leng)
c
c     z: real*8. input.  vertical height in m.
c  cosz: real*8. input.  cos of zenith angle at z.
c   leng: real*8. input.  length along cosz direction.
c   function value.      thickness of air in kg/m2.
c
      implicit none
#include  "Ztrackp.h"
      real*8 z, cosz, leng, clen2thickEx, clen2thickAp
      if(ExactThick) then
         clen2thick = clen2thickEx(z, cosz, leng)
      elseif(abs(cosz) .gt. 0.5) then
         clen2thick = clen2thickAp(z, cosz, leng)
      else
         clen2thick = clen2thickEx(z, cosz, leng)
      endif
      end
c     cLen2thickAp
c
c     Thickness of air corresponding to a gine length along
c     a given direction from a given height.
c
c        test program
c     include 'catmosutil.f'
c     include 'cstdatmos0.f'
c     include '../../KKlib/k16pGaussLeg.f'
c     include 'clen2thickEx.f'
c
c     program testclen2thickAp
c     implicit none
c     real*8 z, cosz, leng, thick, thicka
c
c     real*8 clen2thickAp, clen2thickEx
c
c     z = 6000.
c     cosz = 1.
c     leng = 3000.
c     write(*, *) " enter z, cosz, leng=",z, cosz, leng
c     read(*,*) z, cosz, leng
c     thick = clen2thickEx(z, cosz, leng)
c     thicka = clen2thickAp(z, cosz, leng)
c     write(*, *) ' thick exact =',thick, ' apprxo = ', thicka
c     end
c     ========================================
      real*8 function clen2thickAp(z, cosz, leng)
c
c     z: real*8. input.  vertical height in m.
c  cosz: real*8. input.  cos of zenith angle at z.
c   leng: real*8. input.  length along cosz direction.
c   function value.      thickness of air in kg/m2.
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"

      real*8 z, cosz, leng
c

      real*8 cosm, rs, re, cvh2thick, cnewcos, ze, t1, t2,
     *  cnewh



      rs = z + Eradius
      re = cnewh(rs, cosz, leng)
      ze = re - Eradius
      cosm = cnewcos(rs, cosz, leng/2)
      t1 = cvh2thick(z)
      t2 = cvh2thick(ze)
      clen2thickAp = (t2 - t1)/cosm
      end
c     Exact thickness of air corresponding to a gine length along
c     a given direction from a given height.
c     This uses numerical integration.
c
c        test program
c      include '../../KKlib/k16pGaussLeg.f'
c      include 'catmosutil.f'
c      include 'cstdatmos0.f'
c
c      program testclen2thickEx
c      implicit none
c      real*8 z, cosz, leng, thick
c
c      real*8 clen2thickEx, cvh2thick
c
c      z = 6000.
c      cosz = 1.
c      leng = 3000.
c      thick = clen2thickEx(z, cosz, leng)
c      write(*, *) ' cos=',cosz,' leng =',leng, ' thick=',thick
c      thick = cvh2thick(z-leng*cosz) - cvh2thick(z)
c      write(*, *) ' thick=', thick
c      end
c     ========================================
      real*8 function clen2thickEx(z, cosz, leng)
c
c     z: real*8. input.  vertical height in m.
c  cosz: real*8. input.  cos of zenith angle at z.
c   leng: real*8. input.  length along cosz direction.
c   function value.      thickness of air in kg/m2.
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"

      real*8 z, cosz, leng
c
      real*8  seg/1000./, ans, a, b, inte
c
      external catmosrho
      real*8 catmosrho

      common /ccatmosrho/ coss, rs
      real*8 coss, rs
      integer n/10/

      inte =  0.
      b  =0.
      coss = cosz
      rs = z + Eradius
      do while (.true.)
         a = b
         b = min(leng, a + seg)
         call k16pGaussLeg(catmosrho, a, b, n, ans)
         inte = inte + ans
c         write(*, *) 'a =', a, ' b=',b, ' ans=',ans
         if(b .eq. leng) goto 10
      enddo
 10   continue
      clen2thickEx = inte
      end
