c     ******************************************************************
c     *                                                                *
c     * cobAS: creates air shower from a given electron and observes it*
c     *                                                                *
c     ******************************************************************
c
c
      subroutine cobAS(el)
      implicit none
#include "Ztrack.h"
#include "Zobs.h"
#include "Zobsv.h"
#include "Zelemagp.h"

      record /track/ el    ! an electron to produce A.S

      integer l
      real*8  zobas, zp,  clenbetween2h, length, clen2thick
      real*8  t, elog, eno, age
      real*8  enoc/1./
      zp = el.pos.depth      ! depth of electron

      do   l=1, NoOfASSites
c           vertical depth kg/m2
        zobas=ASObsSites(l).pos.depth
        if(zp .lt. zobas) then
c                starting depth < obsv depth;  convert to air thick-
c                ness to r.l
            if(abs(el.vec.coszenith) .gt. 0.5) then
               t=(zobas-zp)/X0/abs(el.vec.coszenith)
            else
c                  slant lenngth between two depths
               length = clenbetween2h(el.pos.radiallen, 
     *                  ASObsSites(l).pos.radiallen,
     *                  el.vec.coszenith)
               t = clen2thick(el.pos.height, el.vec.coszenith,
     *                        length) / X0
            endif
c                log of electron energy in unit of critical energy
            elog = log10(el.p.fm.p(4)/Ecrit) 
c                        !-get ne and age
            call cNeByApproxB(3, elog, t,   eno, age)
c                 count ne
c              if thins=T, wgt may be diff. from 1.
             eno=eno*el.wgt
c
             ASObsSites(l).esize=ASObsSites(l).esize + eno
             ASObsSites(l).age = ASObsSites(l).age + eno*age
             if(eno .lt. enoc) then
c                     ne is very small
                if( age .gt. 1.) then
c                     old so that cannot become larger; discard it
                   goto 600
                else
c                     age is young, a.s might become larger
                endif
c
             else
c                  ne is large.  if needed, lateral obs.

             endif
        endif
       enddo
  600 continue
      end
