c        ***********************************************************
c        *
c        * csampCollInA: sample # of collisions inside nucleus
c        *
c        *************** tested 88.08.03***********************k.k**
c
c    Hadron nucleus collision is decompsed into successive
c         collision of incident hadron (p, pi, etc)
c         with nucleon inside the nucleus. This program
c         obtains the # of successive collisions.
c   /usage/ call csampCollInA(proj, ia, nc)
c       proj: /ptcl/   input. projectile ptcl
c         nc: output.  # of collistions sampled
c   /method/
c       Using wood-saxon density of nucleus, simplified
c         glauber calculation is done by using cwoodsaxon_den etc.
c         its results for 
c         A**(1/3) = 4**(1/3) to 208**(1/3) with step (tatal width)/15
c         and for elementary cross sections log10(15mb) to log10(300mb)
c         step (total width)/15  is tabulated. (cumProb.h)
c      Because of the descrete nature of the table, the average number
c      could be 10 % smaller than what would be obtained by
c      exact table.  The distributions for very high energy and 
c      very high mass targeti are not accurate; they will not be
c      used in actual case.
c 
        subroutine csampCollInA(pj, ia,  nc)
        implicit none

#include  "Zcode.h"
#include  "Zptcl.h"
        integer i
        record /ptcl/ pj  !input projectile particle
        integer ia       ! target mass no.
        integer nc       ! output number of collisions.

        real*8 a1, a2, a3, da
        real*8  a, xs
c
        integer  idxa, idxxs

        real*8 u
        real*8  xs1, xs2, dxs
        integer mm, nn, kk
        parameter( mm = 14, nn = 16,  kk= 16)
c                 cumProb,  xsec     A

        real*4 cumProb(mm, nn, kk)




c        parameter (a1 = 4.0**0.3333333, a2 = 208.**0.333333333333,
        parameter (a1 = 1.5874011, a2 = 5.9249921,
     *  da = (a2-a1)/(kk-1) )

c         parameter ( xs1 =log10(15.), xs2 =log10(300.) )
        parameter ( xs1 = 1.176091259, xs2 = 2.477121255, 
     *  dxs =( xs2 - xs1)/15.)

#include  "cumProb.h"
c             get cross-section for proton target.        
        call cxpXsec(pj, xs)
        xs = log10(xs)
c
         a = ia
         a3 = a**0.3333333333
         idxa = (a3- a1)/da + 1
         idxxs = (xs - xs1)/dxs + 1
         if( (a3 - idxa * da - a1) .gt. (idxa*da + da + a1 - a3) ) then
            idxa = idxa  + 1
         endif
         idxa = min(idxa, kk)

         if( (xs - idxxs * dxs - xs1) .gt.
     *        (idxxs * dxs + dxs + xs1 - xs) ) then
            idxxs = idxxs +1
         endif
         idxxs = min(idxxs, nn)

         call rndc(u)
         do   i=1,  mm
            if(u .le. cumProb(i, idxxs, idxa) ) then
               nc=i
               goto 100
            endif
         enddo
  100    continue
        end
