c        **********************************************************
c        *
c        *  stzss: s(age) to z(depth) of the standard shower
c        *  ztsss: z(depth) to s(age) //
c        *
c        **********************************************************
c
c ** depth  (g/cm**2) should be taken as a slant one if incident
c            is inclined.
c
        subroutine stzss(s, z)
c
c          log10(150 (tev))
           data elgs/2.175/
c
c            get cog normalized detph (standard is electron of 100 tev)
c            with z0=50 g/cm**2.(s=1.075)  we may use gamma routine
c            with  150  tev. (s=1.075===>z=600)
           call stndg(elgs, s, z)
c             get <cog> depth (exclude 1st point)
           call cogg0(elgs, cog)
c             add 50 g/cm**2
           z=z + cog + 50.
           if(z .le. 0.) then
               z=5.
           endif
           return
c            z to s of the standard shower
c        *********
         entry ztsss(z, s)
c        *********
c             get <cog> depth (exclude 1st point)
           call cogg0(elgs, cog)
c             get normalized depth
           zn=z-cog-50.
c             get age
           call ndtsg(elgs, zn,   s)
         end
